/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.config;

import io.prometheus.metrics.config.ExemplarsProperties;
import io.prometheus.metrics.config.ExporterFilterProperties;
import io.prometheus.metrics.config.ExporterHttpServerProperties;
import io.prometheus.metrics.config.ExporterOpenTelemetryProperties;
import io.prometheus.metrics.config.ExporterProperties;
import io.prometheus.metrics.config.ExporterPushgatewayProperties;
import io.prometheus.metrics.config.MetricsProperties;
import io.prometheus.metrics.config.PrometheusPropertiesException;
import io.prometheus.metrics.config.PrometheusPropertiesLoader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class PrometheusProperties {
    private static final PrometheusProperties instance = PrometheusPropertiesLoader.load();
    private final MetricsProperties defaultMetricsProperties;
    private final Map<String, MetricsProperties> metricProperties = new HashMap<String, MetricsProperties>();
    private final ExemplarsProperties exemplarProperties;
    private final ExporterProperties exporterProperties;
    private final ExporterFilterProperties exporterFilterProperties;
    private final ExporterHttpServerProperties exporterHttpServerProperties;
    private final ExporterOpenTelemetryProperties exporterOpenTelemetryProperties;
    private final ExporterPushgatewayProperties exporterPushgatewayProperties;

    public static PrometheusProperties get() throws PrometheusPropertiesException {
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public PrometheusProperties(MetricsProperties defaultMetricsProperties, Map<String, MetricsProperties> metricProperties, ExemplarsProperties exemplarProperties, ExporterProperties exporterProperties, ExporterFilterProperties exporterFilterProperties, ExporterHttpServerProperties httpServerConfig, ExporterPushgatewayProperties pushgatewayProperties, ExporterOpenTelemetryProperties otelConfig) {
        this.defaultMetricsProperties = defaultMetricsProperties;
        this.metricProperties.putAll(metricProperties);
        this.exemplarProperties = exemplarProperties;
        this.exporterProperties = exporterProperties;
        this.exporterFilterProperties = exporterFilterProperties;
        this.exporterHttpServerProperties = httpServerConfig;
        this.exporterPushgatewayProperties = pushgatewayProperties;
        this.exporterOpenTelemetryProperties = otelConfig;
    }

    public MetricsProperties getDefaultMetricProperties() {
        return this.defaultMetricsProperties;
    }

    @Nullable
    public MetricsProperties getMetricProperties(String metricName) {
        return this.metricProperties.get(metricName.replace(".", "_"));
    }

    public ExemplarsProperties getExemplarProperties() {
        return this.exemplarProperties;
    }

    public ExporterProperties getExporterProperties() {
        return this.exporterProperties;
    }

    public ExporterFilterProperties getExporterFilterProperties() {
        return this.exporterFilterProperties;
    }

    public ExporterHttpServerProperties getExporterHttpServerProperties() {
        return this.exporterHttpServerProperties;
    }

    public ExporterPushgatewayProperties getExporterPushgatewayProperties() {
        return this.exporterPushgatewayProperties;
    }

    public ExporterOpenTelemetryProperties getExporterOpenTelemetryProperties() {
        return this.exporterOpenTelemetryProperties;
    }

    public static class Builder {
        private MetricsProperties defaultMetricsProperties = MetricsProperties.builder().build();
        private Map<String, MetricsProperties> metricProperties = new HashMap<String, MetricsProperties>();
        private ExemplarsProperties exemplarProperties = ExemplarsProperties.builder().build();
        private ExporterProperties exporterProperties = ExporterProperties.builder().build();
        private ExporterFilterProperties exporterFilterProperties = ExporterFilterProperties.builder().build();
        private ExporterHttpServerProperties exporterHttpServerProperties = ExporterHttpServerProperties.builder().build();
        private ExporterPushgatewayProperties pushgatewayProperties = ExporterPushgatewayProperties.builder().build();
        private ExporterOpenTelemetryProperties otelConfig = ExporterOpenTelemetryProperties.builder().build();

        private Builder() {
        }

        public Builder defaultMetricsProperties(MetricsProperties defaultMetricsProperties) {
            this.defaultMetricsProperties = defaultMetricsProperties;
            return this;
        }

        public Builder metricProperties(Map<String, MetricsProperties> metricProperties) {
            this.metricProperties = metricProperties;
            return this;
        }

        public Builder putMetricProperty(String name, MetricsProperties props) {
            this.metricProperties.put(name, props);
            return this;
        }

        public Builder exemplarProperties(ExemplarsProperties exemplarProperties) {
            this.exemplarProperties = exemplarProperties;
            return this;
        }

        public Builder exporterProperties(ExporterProperties exporterProperties) {
            this.exporterProperties = exporterProperties;
            return this;
        }

        public Builder exporterFilterProperties(ExporterFilterProperties exporterFilterProperties) {
            this.exporterFilterProperties = exporterFilterProperties;
            return this;
        }

        public Builder exporterHttpServerProperties(ExporterHttpServerProperties exporterHttpServerProperties) {
            this.exporterHttpServerProperties = exporterHttpServerProperties;
            return this;
        }

        public Builder pushgatewayProperties(ExporterPushgatewayProperties pushgatewayProperties) {
            this.pushgatewayProperties = pushgatewayProperties;
            return this;
        }

        public Builder exporterOpenTelemetryProperties(ExporterOpenTelemetryProperties exporterOpenTelemetryProperties) {
            this.otelConfig = exporterOpenTelemetryProperties;
            return this;
        }

        public PrometheusProperties build() {
            return new PrometheusProperties(this.defaultMetricsProperties, this.metricProperties, this.exemplarProperties, this.exporterProperties, this.exporterFilterProperties, this.exporterHttpServerProperties, this.pushgatewayProperties, this.otelConfig);
        }
    }
}

