/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util.logging;

import io.prometheus.metrics.core.datapoints.DistributionDataPoint;
import io.prometheus.metrics.core.metrics.Histogram;
import io.prometheus.metrics.model.snapshots.Unit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PrometheusAspect {
    private static final Histogram histogram = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.builder().help("OpenMeetings Application Metrics")).name("org_openmeetings_metrics")).labelNames(new String[]{"class", "method", "type", "message"})).register();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object logExecutionTime(ProceedingJoinPoint joinPoint, String logType) throws Throwable {
        Object object;
        String className = joinPoint.getSignature().getDeclaringType().getSimpleName();
        String methodName = joinPoint.getSignature().getName();
        long start = System.nanoTime();
        try {
            object = joinPoint.proceed();
        }
        catch (Throwable throwable) {
            ((DistributionDataPoint)histogram.labelValues(new String[]{className, methodName, logType, "default"})).observe(Unit.nanosToSeconds((long)(System.nanoTime() - start)));
            throw throwable;
        }
        ((DistributionDataPoint)histogram.labelValues(new String[]{className, methodName, logType, "default"})).observe(Unit.nanosToSeconds((long)(System.nanoTime() - start)));
        return object;
    }

    @Around(value="@annotation(TimedDatabase)")
    public Object logExecutionTime(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logExecutionTime(joinPoint, "database");
    }

    @Around(value="@annotation(TimedApplication)")
    public Object logExecutionTimedApplication(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logExecutionTime(joinPoint, "application");
    }
}

