/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoHelper {
    private static final Logger log = LoggerFactory.getLogger(DaoHelper.class);
    public static final UnsupportedOperationException UNSUPPORTED = new UnsupportedOperationException("Should not be used");

    private DaoHelper() {
    }

    public static String getStringParam(String param) {
        return "%" + StringUtils.lowerCase((String)param, (Locale)Locale.ROOT) + "%";
    }

    public static <T> long count(EntityManager em, Class<T> clazz, String search, List<String> searchFields, boolean noDeleted, BiFunction<CriteriaBuilder, CriteriaQuery<?>, Predicate> filter) {
        return DaoHelper.count(em, clazz, CriteriaBuilder::count, search, searchFields, noDeleted, filter);
    }

    public static <T> long count(EntityManager em, Class<T> clazz, BiFunction<CriteriaBuilder, Root<T>, Expression<Long>> queuePath, String search, List<String> searchFields, boolean noDeleted, BiFunction<CriteriaBuilder, CriteriaQuery<?>, Predicate> filter) {
        CriteriaQuery<Long> query = DaoHelper.query(em, clazz, Long.class, queuePath, false, search, searchFields, noDeleted, filter, null);
        return (Long)em.createQuery(query).getSingleResult();
    }

    public static <T> List<T> get(EntityManager em, Class<T> clazz, boolean distinct, String search, List<String> searchFields, boolean noDeleted, BiFunction<CriteriaBuilder, CriteriaQuery<?>, Predicate> filter, SortParam<String> sort, long start, long count) {
        return DaoHelper.get(em, clazz, clazz, (builder, root) -> root, distinct, search, searchFields, noDeleted, filter, sort, start, count);
    }

    public static <T, R> List<T> get(EntityManager em, Class<R> rootClazz, Class<T> clazz, BiFunction<CriteriaBuilder, Root<R>, Expression<T>> queuePath, boolean distinct, String search, List<String> searchFields, boolean noDeleted, BiFunction<CriteriaBuilder, CriteriaQuery<?>, Predicate> filter, SortParam<String> sort, long start, long count) {
        CriteriaQuery<T> query = DaoHelper.query(em, rootClazz, clazz, queuePath, distinct, search, searchFields, noDeleted, filter, sort);
        return DaoHelper.setLimits(em.createQuery(query), start, count).getResultList();
    }

    public static <T, R> CriteriaQuery<T> query(EntityManager em, Class<R> rootClazz, Class<T> clazz, BiFunction<CriteriaBuilder, Root<R>, Expression<T>> queuePath, boolean distinct, String search, List<String> searchFields, boolean noDeleted, BiFunction<CriteriaBuilder, CriteriaQuery<?>, Predicate> filter, SortParam<String> sort) {
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(clazz);
        Root root = query.from(rootClazz);
        query.select((Selection)queuePath.apply(builder, root));
        if (distinct) {
            query.distinct(distinct);
        }
        query.where((Expression)DaoHelper.search(search, searchFields, noDeleted, filter, builder, root, query));
        DaoHelper.sort(sort, builder, root, query);
        return query;
    }

    public static <T, Q> Predicate search(String search, List<String> searchFields, boolean noDeleted, BiFunction<CriteriaBuilder, CriteriaQuery<?>, Predicate> filter, CriteriaBuilder builder, Root<T> root, CriteriaQuery<Q> query) {
        Predicate result = builder.isNull(null);
        if (noDeleted) {
            result = builder.and((Expression)result, (Expression)builder.equal((Expression)root.get("deleted"), (Object)false));
        }
        if (filter != null) {
            result = builder.and((Expression)result, (Expression)filter.apply(builder, query));
        }
        if (!Strings.isEmpty((String)search)) {
            Predicate[] criterias = (Predicate[])Stream.of(search.replace("'", "").replace("\"", "").split(" ")).filter(searchItem -> !searchItem.isEmpty()).map(DaoHelper::getStringParam).flatMap(searchItem -> searchFields.stream().map(col -> DaoHelper.like(col, searchItem, builder, root))).toArray(Predicate[]::new);
            result = builder.and((Expression)result, (Expression)builder.or(criterias));
        }
        return result;
    }

    public static <T> Predicate like(String col, String searchItem, CriteriaBuilder builder, Path<T> root) {
        String[] cols;
        Path colPath = null;
        for (String s : cols = col.split("[.]")) {
            colPath = colPath == null ? root.get(s) : colPath.get(s);
        }
        return builder.like(builder.lower(colPath), "%" + searchItem + "%");
    }

    public static <T, Q> void sort(SortParam<String> sort, CriteriaBuilder builder, Root<T> root, CriteriaQuery<Q> query) {
        if (sort != null && !Strings.isEmpty((String)((String)sort.getProperty()))) {
            query.orderBy(new Order[]{sort.isAscending() ? builder.asc((Expression)root.get((String)sort.getProperty())) : builder.desc((Expression)root.get((String)sort.getProperty()))});
        }
    }

    public static <T> TypedQuery<T> setLimits(TypedQuery<T> q, Long first, Long max) {
        if (first != null) {
            q.setFirstResult(first.intValue());
        }
        if (max != null) {
            q.setMaxResults(max.intValue());
        }
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> fillLazy(EntityManager em, Function<OpenJPAEntityManager, TypedQuery<T>> func, String ... groups) {
        OpenJPAEntityManager oem = OpenJPAPersistence.cast((EntityManager)em);
        boolean qrce = oem.getFetchPlan().getQueryResultCacheEnabled();
        try {
            oem.getFetchPlan().setQueryResultCacheEnabled(false);
            TypedQuery<T> q = func.apply(oem);
            OpenJPAQuery kq = OpenJPAPersistence.cast(q);
            kq.getFetchPlan().addFetchGroups(groups);
            List list = kq.getResultList();
            return list;
        }
        finally {
            oem.getFetchPlan().setQueryResultCacheEnabled(qrce);
        }
    }

    public static <T> T single(List<T> l) {
        return l.isEmpty() ? null : (T)l.get(0);
    }

    public static <T> T only(List<T> l) {
        if (l.size() > 1) {
            log.error("More than one ({}) record found", (Object)l.size());
        }
        return l.isEmpty() ? null : (T)l.get(0);
    }

    public static <T> Root<T> getRoot(CriteriaQuery<?> query, Class<T> clazz) {
        return query.getRoots().stream().filter(r -> clazz.equals(r.getModel().getJavaType())).map(r -> r).findAny().orElseThrow();
    }

    public static Subquery<Long> groupAdminQuery(Long userId, CriteriaBuilder builder, AbstractQuery<?> parentQ) {
        Subquery query = parentQ.subquery(Long.class);
        Root root = query.from(GroupUser.class);
        query.select((Expression)root.get("group").get("id"));
        query.where((Expression)builder.and((Expression)builder.isTrue((Expression)root.get("moderator")), (Expression)builder.equal((Expression)root.get("user").get("id"), (Object)userId)));
        return query;
    }
}

