/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconType;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Optional;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.StoredFile;
import org.apache.openmeetings.web.common.ImagePanel;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.util.upload.BootstrapFileUploadBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadProgressBar;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UploadableImagePanel
extends ImagePanel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(UploadableImagePanel.class);
    private static final String ERROR = "Error";
    private final FileUploadField fileUploadField = new FileUploadField("image", (IModel)new ListModel());
    private final Form<Void> form = new Form("form");
    private final boolean delayed;
    private HiddenField<Boolean> deleted = new HiddenField("imgDeleted", (IModel)Model.of((Serializable)Boolean.valueOf(false)));

    protected UploadableImagePanel(String id, boolean delayed) {
        super(id);
        this.delayed = delayed;
    }

    protected abstract void processImage(StoredFile var1, File var2) throws Exception;

    protected abstract void deleteImage() throws Exception;

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.form.setMultiPart(true);
        this.form.setMaxSize(Bytes.bytes((long)OpenmeetingsVariables.getMaxUploadSize()));
        this.form.add(new Component[]{this.fileUploadField, this.deleted});
        this.form.add(new Component[]{new UploadProgressBar("progress", this.form, this.fileUploadField)});
        this.form.addOrReplace(new Component[]{this.getImage()});
        if (this.delayed) {
            this.add(new Component[]{new WebMarkupContainer("remove")});
        } else {
            BootstrapAjaxLink<String> remove = new BootstrapAjaxLink<String>("remove", Buttons.Type.Outline_Secondary){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    try {
                        UploadableImagePanel.this.deleteImage();
                    }
                    catch (Exception e) {
                        log.error(UploadableImagePanel.ERROR, (Throwable)e);
                    }
                    UploadableImagePanel.this.update(Optional.of(target));
                }
            };
            this.add(new Component[]{remove.setIconType((IconType)FontAwesome6IconType.xmark_s).add(new Behavior[]{ConfirmationHelper.newOkCancelConfirm((Component)this, this.getString("833"))})});
            this.fileUploadField.add(new Behavior[]{new AjaxFormSubmitBehavior(this.form, "change"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    UploadableImagePanel.this.process(Optional.of(target));
                }
            }});
        }
        this.add(new Component[]{this.form.setOutputMarkupId(true)});
        this.add(new Behavior[]{BootstrapFileUploadBehavior.getInstance()});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.delayed) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)"(function(){\n\tconst form = $('#%s')\n\t\t, fileinput = form.find('.fileinput')\n\t\t, deleted = form.find('#imgDeleted');\n\tfileinput.off('change.bs.fileinput').on('change.bs.fileinput', function() {\n\t\tdeleted.val(false);\n\t});\n\tform.siblings('.remove').off()\n\t\t.click(function() {\n\t\t\tfileinput.fileinput('clear');\n\t\t\tdeleted.val(true);\n\t\t});\n})();\n".formatted(this.form.getMarkupId())));
        }
    }

    @Override
    public void update() {
        this.deleted.setModelObject((Object)false);
        this.profile.addOrReplace(new Component[]{new WebMarkupContainer("img").setVisible(false)});
        this.form.addOrReplace(new Component[]{this.getImage()});
    }

    private void update(Optional<AjaxRequestTarget> target) {
        this.update();
        target.ifPresent(t -> t.add(new Component[]{this.profile, this.form}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImage(FileUpload fu) {
        if (fu != null) {
            try {
                File temp = null;
                try {
                    temp = fu.writeToTempFile();
                    StoredFile sf = new StoredFile(fu.getClientFileName(), temp);
                    if (sf.isImage()) {
                        this.processImage(sf, temp);
                    }
                }
                finally {
                    if (temp != null) {
                        log.debug("Temp file was deleted ? {}", (Object)Files.deleteIfExists(temp.toPath()));
                    }
                    fu.closeStreams();
                    fu.delete();
                }
            }
            catch (Exception e) {
                log.error(ERROR, (Throwable)e);
            }
        }
    }

    public void process(Optional<AjaxRequestTarget> target) {
        if (this.delayed && Boolean.TRUE.equals(this.deleted.getModelObject())) {
            try {
                this.deleteImage();
            }
            catch (Exception e) {
                log.error(ERROR, (Throwable)e);
            }
        } else {
            FileUpload fu = this.fileUploadField.getFileUpload();
            this.processImage(fu);
        }
        this.update(target);
    }
}

