/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.ParameterMode;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TemporalType;
import org.apache.openjpa.kernel.DelegatingResultList;
import org.apache.openjpa.kernel.QueryResultCallback;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.MultiQueryMetaData;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.ParameterImpl;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.util.RuntimeExceptionTranslator;
import org.apache.openjpa.util.UserException;

public class StoredProcedureQueryImpl
implements StoredProcedureQuery {
    private static final Localizer _loc = Localizer.forPackage(QueryImpl.class);
    private final String _name;
    private final QueryImpl<?> _delegate;
    private final MultiQueryMetaData _meta;
    private QueryResultCallback _callback;
    private boolean _declaredParams;

    public StoredProcedureQueryImpl(String procedureName, MultiQueryMetaData meta, QueryImpl<?> delegate) {
        this._name = procedureName;
        if (!this.isValidProcedureName(procedureName)) {
            throw new RuntimeException(procedureName + " is not a valid procedure name");
        }
        this._meta = meta;
        this._delegate = delegate;
        this._delegate.compile();
    }

    public OpenJPAQuery<?> getDelegate() {
        return this._delegate;
    }

    public org.apache.openjpa.kernel.Query getExecutableQuery() {
        return this._delegate.getDelegate();
    }

    private void buildParametersIfNeeded() {
        if (!this._declaredParams) {
            for (MultiQueryMetaData.Parameter entry : this._meta.getParameters()) {
                ParameterImpl param;
                Object key;
                if (entry.getName() == null) {
                    key = entry.getPosition();
                    param = new ParameterImpl(entry.getPosition(), entry.getType());
                } else {
                    key = entry.getName();
                    param = new ParameterImpl(entry.getName(), entry.getType());
                }
                this._delegate.declareParameter(key, param);
            }
            this._declaredParams = true;
        }
    }

    @Override
    public boolean execute() {
        if (this._callback == null) {
            this._callback = (QueryResultCallback)this.getExecutableQuery().execute(this._delegate.getParameterValues());
        }
        return this._callback.getExecutionResult();
    }

    @Override
    public List getResultList() {
        this.execute();
        try {
            Object list = this._callback.callback();
            RuntimeExceptionTranslator trans = PersistenceExceptions.getRollbackTranslator(this._delegate.getEntityManager());
            return new DelegatingResultList((ResultList)list, trans);
        }
        catch (Exception ex) {
            throw new PersistenceException(ex);
        }
    }

    @Override
    public Object getSingleResult() {
        this.execute();
        try {
            ResultList result = (ResultList)this._callback.callback();
            if (result == null || result.isEmpty()) {
                throw new NoResultException(_loc.get("no-result", this._name).getMessage());
            }
            if (result.size() > 1) {
                throw new NonUniqueResultException(_loc.get("non-unique-result", this._name, result.size()).getMessage());
            }
            RuntimeExceptionTranslator trans = PersistenceExceptions.getRollbackTranslator(this._delegate.getEntityManager());
            return new DelegatingResultList(result, trans).iterator().next();
        }
        catch (Exception ex) {
            throw new PersistenceException(ex);
        }
    }

    @Override
    public boolean hasMoreResults() {
        return this._callback != null && this._callback.hasMoreResults();
    }

    @Override
    public int getUpdateCount() {
        this.assertExecuted();
        return this._callback.getUpdateCount();
    }

    @Override
    public int executeUpdate() {
        this.execute();
        return this._callback.getUpdateCount();
    }

    @Override
    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return this._delegate.getParameter(name, type);
    }

    @Override
    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        return this._delegate.getParameter(position, type);
    }

    @Override
    public boolean isBound(Parameter<?> param) {
        return this._delegate.isBound(param);
    }

    @Override
    public <T> T getParameterValue(Parameter<T> param) {
        return this._delegate.getParameterValue(param);
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        return this._delegate.unwrap(cls);
    }

    @Override
    public <T> StoredProcedureQuery setParameter(Parameter<T> param, T value) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter((Parameter)param, (Object)value);
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(Parameter<Calendar> param, Calendar cal, TemporalType temporalType) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter((Parameter)param, cal, temporalType);
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public StoredProcedureQuery registerStoredProcedureParameter(int position, Class type, ParameterMode mode) {
        this.buildParametersIfNeeded();
        ParameterImpl param = new ParameterImpl(position, type);
        this._delegate.declareParameter(position, param);
        return this;
    }

    @Override
    public StoredProcedureQuery registerStoredProcedureParameter(String name, Class type, ParameterMode mode) {
        this.buildParametersIfNeeded();
        ParameterImpl param = new ParameterImpl(name, type);
        this._delegate.declareParameter(name, param);
        return this;
    }

    @Override
    public Object getOutputParameterValue(int position) {
        return this._callback == null ? null : this._callback.getOut(position);
    }

    @Override
    public Object getOutputParameterValue(String parameterName) {
        return this._callback == null ? null : this._callback.getOut(parameterName);
    }

    @Override
    public Query setMaxResults(int maxResult) {
        return this._delegate.setMaxResults(maxResult);
    }

    @Override
    public int getMaxResults() {
        return this._delegate.getMaxResults();
    }

    @Override
    public Query setFirstResult(int startPosition) {
        return this._delegate.setFirstResult(startPosition);
    }

    @Override
    public int getFirstResult() {
        return this._delegate.getFirstResult();
    }

    @Override
    public Map<String, Object> getHints() {
        return this._delegate.getHints();
    }

    @Override
    public Set<Parameter<?>> getParameters() {
        this.buildParametersIfNeeded();
        return this._delegate.getParameters();
    }

    @Override
    public Parameter<?> getParameter(String name) {
        this.buildParametersIfNeeded();
        return this._delegate.getParameter(name);
    }

    @Override
    public Parameter<?> getParameter(int position) {
        this.buildParametersIfNeeded();
        return this._delegate.getParameter(position);
    }

    @Override
    public Object getParameterValue(String name) {
        this.buildParametersIfNeeded();
        return this._delegate.getParameterValue(name);
    }

    @Override
    public Object getParameterValue(int position) {
        this.buildParametersIfNeeded();
        return this._delegate.getParameter(position);
    }

    @Override
    public FlushModeType getFlushMode() {
        return this._delegate.getFlushMode();
    }

    @Override
    public Query setLockMode(LockModeType lockMode) {
        return this._delegate.setLockMode(lockMode);
    }

    @Override
    public LockModeType getLockMode() {
        return this._delegate.getLockMode();
    }

    @Override
    public StoredProcedureQuery setHint(String hintName, Object value) {
        this._delegate.setHint(hintName, value);
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(String name, Object value) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(name, value);
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(String name, Calendar cal, TemporalType temporalType) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(name, cal, temporalType);
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(String name, Date date, TemporalType temporalType) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(name, date, temporalType);
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(int position, Object value) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(position, value);
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(int position, Calendar value, TemporalType temporalType) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public StoredProcedureQuery setParameter(int position, Date value, TemporalType temporalType) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public StoredProcedureQuery setFlushMode(FlushModeType flushMode) {
        this._delegate.setFlushMode(flushMode);
        return this;
    }

    void assertExecuted() {
        if (this._callback == null) {
            throw new UserException(this + " has not been executed");
        }
    }

    boolean isValidProcedureName(String s) {
        if (s == null || s.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '#' || ch == '$' || Character.isJavaIdentifierPart(ch)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this._name;
    }
}

