/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.util.Comparator;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.Order;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.ImplHelper;

class InMemoryValueOrder
implements Order,
Comparator {
    private final boolean _asc;
    private final OpenJPAConfiguration _conf;

    public InMemoryValueOrder(boolean asc, OpenJPAConfiguration conf) {
        this._asc = asc;
        this._conf = conf;
    }

    @Override
    public String getName() {
        return "#element";
    }

    @Override
    public boolean isAscending() {
        return this._asc;
    }

    @Override
    public Comparator getComparator() {
        return this;
    }

    public int compare(Object o1, Object o2) {
        int cmp;
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return this._asc ? -1 : 1;
        }
        if (o2 == null) {
            return this._asc ? 1 : -1;
        }
        if (!ImplHelper.isManageable(o1) || !ImplHelper.isManageable(o2)) {
            int cmp2 = ((Comparable)o1).compareTo(o2);
            return this._asc ? cmp2 : -cmp2;
        }
        PersistenceCapable pc1 = ImplHelper.toPersistenceCapable(o1, this._conf);
        PersistenceCapable pc2 = ImplHelper.toPersistenceCapable(o2, this._conf);
        OpenJPAStateManager sm1 = (OpenJPAStateManager)pc1.pcGetStateManager();
        OpenJPAStateManager sm2 = (OpenJPAStateManager)pc2.pcGetStateManager();
        if (sm1 == null || sm2 == null) {
            return 0;
        }
        Object[] pk1 = InMemoryValueOrder.toPKValues(sm1);
        Object[] pk2 = InMemoryValueOrder.toPKValues(sm2);
        int len = Math.min(pk1.length, pk2.length);
        for (int i = 0; i < len; ++i) {
            if (pk1[i] == pk2[i]) {
                return 0;
            }
            if (pk1[i] == null) {
                return this._asc ? -1 : 1;
            }
            if (pk2[i] == null) {
                return this._asc ? 1 : -1;
            }
            cmp = ((Comparable)pk1[i]).compareTo(pk2[i]);
            if (cmp == 0) continue;
            return this._asc ? cmp : -cmp;
        }
        cmp = pk1.length - pk2.length;
        return this._asc ? cmp : -cmp;
    }

    private static Object[] toPKValues(OpenJPAStateManager sm) {
        if (sm.getMetaData().getIdentityType() != 2) {
            return new Object[]{sm.getObjectId()};
        }
        Object[] pks = ApplicationIds.toPKValues(sm.getObjectId(), sm.getMetaData());
        if (pks == null) {
            pks = new Object[]{null};
        }
        return pks;
    }
}

