/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.FieldMetaData;

public class Closure
implements Iterable<OpenJPAStateManager> {
    private Set<OpenJPAStateManager> _visited = new LinkedHashSet<OpenJPAStateManager>();

    public Closure(OpenJPAStateManager root) {
        this(Collections.singleton(root));
    }

    public Closure(Collection<OpenJPAStateManager> roots) {
        for (OpenJPAStateManager sm : roots) {
            this.visit(sm);
        }
    }

    private void visit(OpenJPAStateManager sm) {
        FieldMetaData[] fmds;
        boolean isVisited;
        if (sm == null) {
            return;
        }
        boolean bl = isVisited = !this._visited.add(sm);
        if (isVisited) {
            return;
        }
        BitSet loaded = sm.getLoaded();
        block6: for (FieldMetaData fmd : fmds = sm.getMetaData().getFields()) {
            int idx = fmd.getIndex();
            if (!loaded.get(idx) || fmd.getElement().getTypeMetaData() == null && fmd.getValue().getTypeMetaData() == null) continue;
            switch (fmd.getDeclaredTypeCode()) {
                case 15: {
                    this.visit(this.toStateManager(sm.fetch(idx)));
                    continue block6;
                }
                case 11: {
                    Object[] values;
                    for (Object o : values = (Object[])sm.fetch(idx)) {
                        this.visit(this.toStateManager(o));
                    }
                    continue block6;
                }
                case 12: {
                    Collection members = (Collection)sm.fetch(idx);
                    for (Object o : members) {
                        this.visit(this.toStateManager(o));
                    }
                    continue block6;
                }
                case 13: {
                    Map map = (Map)sm.fetch(idx);
                    for (Map.Entry entry : map.entrySet()) {
                        this.visit(this.toStateManager(entry.getKey()));
                        this.visit(this.toStateManager(entry.getValue()));
                    }
                    continue block6;
                }
            }
        }
    }

    OpenJPAStateManager toStateManager(Object o) {
        if (o instanceof PersistenceCapable) {
            return (OpenJPAStateManager)((PersistenceCapable)o).pcGetStateManager();
        }
        return null;
    }

    @Override
    public Iterator<OpenJPAStateManager> iterator() {
        return this._visited.iterator();
    }

    String ior(OpenJPAStateManager sm) {
        return sm.getMetaData().getDescribedType().getSimpleName() + '-' + sm.getObjectId();
    }
}

