/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.debug;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.apache.olingo.odata2.api.exception.ODataMessageException;
import org.apache.olingo.odata2.core.debug.DebugInfo;
import org.apache.olingo.odata2.core.debug.ODataDebugResponseWrapper;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;
import org.apache.olingo.odata2.core.exception.MessageService;

public class DebugInfoException
implements DebugInfo {
    private final Exception exception;
    private final Locale locale;

    public DebugInfoException(Exception exception, Locale locale) {
        this.exception = exception;
        this.locale = locale;
    }

    @Override
    public String getName() {
        return "Stacktrace";
    }

    @Override
    public void appendJson(JsonStreamWriter jsonStreamWriter) throws IOException {
        jsonStreamWriter.beginObject().name("exceptions").beginArray();
        Throwable throwable = this.exception;
        while (throwable != null) {
            jsonStreamWriter.beginObject().namedStringValueRaw("class", throwable.getClass().getCanonicalName()).separator().namedStringValue("message", this.getMessageText(throwable)).separator();
            jsonStreamWriter.name("invocation");
            DebugInfoException.appendJsonStackTraceElement(jsonStreamWriter, throwable.getStackTrace()[0]);
            jsonStreamWriter.endObject();
            if ((throwable = throwable.getCause()) == null) continue;
            jsonStreamWriter.separator();
        }
        jsonStreamWriter.endArray();
        jsonStreamWriter.separator();
        jsonStreamWriter.name("stacktrace").beginArray();
        boolean first = true;
        for (StackTraceElement stackTraceElement : this.exception != null ? this.exception.getStackTrace() : null) {
            if (!first) {
                jsonStreamWriter.separator();
            }
            first = false;
            DebugInfoException.appendJsonStackTraceElement(jsonStreamWriter, stackTraceElement);
        }
        jsonStreamWriter.endArray();
        jsonStreamWriter.endObject();
    }

    private static void appendJsonStackTraceElement(JsonStreamWriter jsonStreamWriter, StackTraceElement stackTraceElement) throws IOException {
        jsonStreamWriter.beginObject().namedStringValueRaw("class", stackTraceElement.getClassName()).separator().namedStringValueRaw("method", stackTraceElement.getMethodName()).separator().name("line").unquotedValue(Integer.toString(stackTraceElement.getLineNumber())).endObject();
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        this.appendException(this.exception, writer);
        writer.append("<h2>Stacktrace</h2>\n");
        int count = 0;
        for (StackTraceElement stackTraceElement : this.exception.getStackTrace()) {
            this.appendStackTraceElement(stackTraceElement, ++count == 1, count == this.exception.getStackTrace().length, writer);
        }
    }

    private void appendException(Throwable throwable, Writer writer) throws IOException {
        if (throwable.getCause() != null) {
            this.appendException(throwable.getCause(), writer);
        }
        StackTraceElement details = throwable.getStackTrace()[0];
        writer.append("<h2>").append(throwable.getClass().getCanonicalName()).append("</h2>\n").append("<p>").append(ODataDebugResponseWrapper.escapeHtml(this.getMessageText(throwable))).append("</p>\n");
        this.appendStackTraceElement(details, true, true, writer);
    }

    private void appendStackTraceElement(StackTraceElement stackTraceElement, boolean isFirst, boolean isLast, Writer writer) throws IOException {
        if (isFirst) {
            writer.append("<table>\n<thead>\n").append("<tr>\n<th class=\"name\">Class</th>\n").append("<th class=\"name\">Method</th>\n").append("<th class=\"value\">Line number in class</th>\n</tr>\n").append("</thead>\n<tbody>\n");
        }
        writer.append("<tr>\n<td class=\"name\">").append(stackTraceElement.getClassName()).append("</td>\n").append("<td class=\"name\">").append(stackTraceElement.getMethodName()).append("</td>\n").append("<td class=\"value\">").append(Integer.toString(stackTraceElement.getLineNumber())).append("</td>\n</tr>\n");
        if (isLast) {
            writer.append("</tbody>\n</table>\n");
        }
    }

    private String getMessageText(Throwable throwable) {
        return throwable instanceof ODataMessageException ? MessageService.getMessage(this.locale, ((ODataMessageException)throwable).getMessageReference()).getText() : (throwable.getLocalizedMessage() == null ? "Exception text missing" : throwable.getLocalizedMessage());
    }
}

