/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.multipart;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.CloseableAsyncRequestBody;
import software.amazon.awssdk.core.async.listener.PublisherListener;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.internal.multipart.CancelledSubscriber;
import software.amazon.awssdk.services.s3.internal.multipart.MpuRequestContext;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartUploadHelper;
import software.amazon.awssdk.services.s3.internal.multipart.SdkPojoConversionUtils;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.multipart.S3MultipartExecutionAttribute;
import software.amazon.awssdk.services.s3.multipart.S3ResumeToken;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public class KnownContentLengthAsyncRequestBodySubscriber
implements Subscriber<CloseableAsyncRequestBody> {
    private static final Logger log = Logger.loggerFor(KnownContentLengthAsyncRequestBodySubscriber.class);
    private final AtomicInteger asyncRequestBodyInFlight = new AtomicInteger(0);
    private final AtomicBoolean failureActionInitiated = new AtomicBoolean(false);
    private final AtomicInteger partNumber = new AtomicInteger(1);
    private final MultipartUploadHelper multipartUploadHelper;
    private final long totalSize;
    private final long partSize;
    private final int expectedNumParts;
    private final int existingNumParts;
    private final String uploadId;
    private final Collection<CompletableFuture<CompletedPart>> futures = new ConcurrentLinkedQueue<CompletableFuture<CompletedPart>>();
    private final PutObjectRequest putObjectRequest;
    private final CompletableFuture<PutObjectResponse> returnFuture;
    private final AtomicReferenceArray<CompletedPart> completedParts;
    private final Map<Integer, CompletedPart> existingParts;
    private final PublisherListener<Long> progressListener;
    private Subscription subscription;
    private volatile boolean isDone;
    private volatile boolean isPaused;
    private final AtomicBoolean completedMultipartInitiated = new AtomicBoolean(false);
    private volatile CompletableFuture<CompleteMultipartUploadResponse> completeMpuFuture;

    KnownContentLengthAsyncRequestBodySubscriber(MpuRequestContext mpuRequestContext, CompletableFuture<PutObjectResponse> returnFuture, MultipartUploadHelper multipartUploadHelper) {
        this.totalSize = mpuRequestContext.contentLength();
        this.partSize = mpuRequestContext.partSize();
        this.expectedNumParts = mpuRequestContext.expectedNumParts();
        this.putObjectRequest = (PutObjectRequest)((Object)mpuRequestContext.request().left());
        this.returnFuture = returnFuture;
        this.uploadId = mpuRequestContext.uploadId();
        this.existingParts = mpuRequestContext.existingParts() == null ? new HashMap() : mpuRequestContext.existingParts();
        this.existingNumParts = NumericUtils.saturatedCast((long)mpuRequestContext.numPartsCompleted());
        this.completedParts = new AtomicReferenceArray(this.expectedNumParts);
        this.multipartUploadHelper = multipartUploadHelper;
        this.progressListener = this.putObjectRequest.overrideConfiguration().map(c -> (PublisherListener)c.executionAttributes().getAttribute(S3MultipartExecutionAttribute.JAVA_PROGRESS_LISTENER)).orElseGet(PublisherListener::noOp);
    }

    public S3ResumeToken pause() {
        this.isPaused = true;
        if (this.completeMpuFuture != null && this.completeMpuFuture.isDone()) {
            return null;
        }
        if (this.completeMpuFuture != null && !this.completeMpuFuture.isDone()) {
            this.completeMpuFuture.cancel(true);
        }
        long numPartsCompleted = 0L;
        for (CompletableFuture<CompletedPart> cf : this.futures) {
            if (!cf.isDone()) {
                cf.cancel(true);
                continue;
            }
            ++numPartsCompleted;
        }
        return S3ResumeToken.builder().uploadId(this.uploadId).partSize(this.partSize).totalNumParts(Long.valueOf(this.expectedNumParts)).numPartsCompleted(numPartsCompleted + (long)this.existingNumParts).build();
    }

    public void onSubscribe(Subscription s) {
        if (this.subscription != null) {
            log.warn(() -> "The subscriber has already been subscribed. Cancelling the incoming subscription");
            this.subscription.cancel();
            return;
        }
        this.subscription = s;
        s.request(1L);
        this.returnFuture.whenComplete((r, t) -> {
            if (t != null) {
                s.cancel();
                if (this.shouldFailRequest()) {
                    this.multipartUploadHelper.failRequestsElegantly(this.futures, (Throwable)t, this.uploadId, this.returnFuture, this.putObjectRequest);
                }
            }
        });
    }

    public void onNext(CloseableAsyncRequestBody asyncRequestBody) {
        if (this.isPaused || this.isDone) {
            return;
        }
        int currentPartNum = this.partNumber.getAndIncrement();
        log.debug(() -> String.format("Received asyncRequestBody for part number %d with length %s", currentPartNum, asyncRequestBody.contentLength()));
        if (this.existingParts.containsKey(currentPartNum)) {
            asyncRequestBody.subscribe(new CancelledSubscriber());
            asyncRequestBody.contentLength().ifPresent(arg_0 -> this.progressListener.subscriberOnNext(arg_0));
            asyncRequestBody.close();
            this.subscription.request(1L);
            return;
        }
        Optional<SdkClientException> sdkClientException = this.validatePart((AsyncRequestBody)asyncRequestBody, currentPartNum);
        if (sdkClientException.isPresent()) {
            this.multipartUploadHelper.failRequestsElegantly(this.futures, (Throwable)sdkClientException.get(), this.uploadId, this.returnFuture, this.putObjectRequest);
            this.subscription.cancel();
            return;
        }
        this.asyncRequestBodyInFlight.incrementAndGet();
        UploadPartRequest uploadRequest = SdkPojoConversionUtils.toUploadPartRequest(this.putObjectRequest, currentPartNum, this.uploadId);
        Consumer<CompletedPart> completedPartConsumer = completedPart -> this.completedParts.set(completedPart.partNumber() - 1, (CompletedPart)completedPart);
        this.multipartUploadHelper.sendIndividualUploadPartRequest(this.uploadId, completedPartConsumer, this.futures, (Pair<UploadPartRequest, AsyncRequestBody>)Pair.of((Object)((Object)uploadRequest), (Object)asyncRequestBody), this.progressListener).whenComplete((r, t) -> {
            asyncRequestBody.close();
            if (t != null) {
                if (this.shouldFailRequest()) {
                    this.multipartUploadHelper.failRequestsElegantly(this.futures, (Throwable)t, this.uploadId, this.returnFuture, this.putObjectRequest);
                    this.subscription.cancel();
                }
            } else {
                this.completeMultipartUploadIfFinished(this.asyncRequestBodyInFlight.decrementAndGet());
            }
        });
        this.subscription.request(1L);
    }

    private Optional<SdkClientException> validatePart(AsyncRequestBody asyncRequestBody, int currentPartNum) {
        if (!asyncRequestBody.contentLength().isPresent()) {
            return Optional.of(MultipartUploadHelper.contentLengthMissingForPart(currentPartNum));
        }
        Long currentPartSize = (Long)asyncRequestBody.contentLength().get();
        if (currentPartNum > this.expectedNumParts) {
            return Optional.of(MultipartUploadHelper.partNumMismatch(this.expectedNumParts, currentPartNum));
        }
        if (currentPartNum == this.expectedNumParts) {
            return this.validateLastPartSize(currentPartSize);
        }
        if (currentPartSize != this.partSize) {
            return Optional.of(MultipartUploadHelper.contentLengthMismatchForPart(this.partSize, currentPartSize, currentPartNum));
        }
        return Optional.empty();
    }

    private Optional<SdkClientException> validateLastPartSize(Long currentPartSize) {
        long expectedLastPartSize;
        long remainder = this.totalSize % this.partSize;
        long l = expectedLastPartSize = remainder == 0L ? this.partSize : remainder;
        if (currentPartSize != expectedLastPartSize) {
            return Optional.of(SdkClientException.create((String)("Content length of the last part must be equal to the expected last part size. Expected: " + expectedLastPartSize + ", Actual: " + currentPartSize)));
        }
        return Optional.empty();
    }

    private boolean shouldFailRequest() {
        return this.failureActionInitiated.compareAndSet(false, true) && !this.isPaused;
    }

    public void onError(Throwable t) {
        log.debug(() -> "Received onError ", t);
        if (this.failureActionInitiated.compareAndSet(false, true)) {
            this.isDone = true;
            this.multipartUploadHelper.failRequestsElegantly(this.futures, t, this.uploadId, this.returnFuture, this.putObjectRequest);
        }
    }

    public void onComplete() {
        log.debug(() -> "Received onComplete()");
        this.isDone = true;
        if (!this.isPaused) {
            this.completeMultipartUploadIfFinished(this.asyncRequestBodyInFlight.get());
        }
    }

    private void completeMultipartUploadIfFinished(int requestsInFlight) {
        if (this.isDone && requestsInFlight == 0 && this.completedMultipartInitiated.compareAndSet(false, true)) {
            CompletedPart[] parts = this.existingParts.isEmpty() ? (CompletedPart[])IntStream.range(0, this.completedParts.length()).mapToObj(this.completedParts::get).toArray(CompletedPart[]::new) : this.mergeCompletedParts();
            int actualNumParts = this.partNumber.get() - 1;
            if (actualNumParts != this.expectedNumParts) {
                SdkClientException exception = MultipartUploadHelper.partNumMismatch(this.expectedNumParts, actualNumParts);
                this.multipartUploadHelper.failRequestsElegantly(this.futures, (Throwable)exception, this.uploadId, this.returnFuture, this.putObjectRequest);
                return;
            }
            this.completeMpuFuture = this.multipartUploadHelper.completeMultipartUpload(this.returnFuture, this.uploadId, parts, this.putObjectRequest, this.totalSize);
        }
    }

    private CompletedPart[] mergeCompletedParts() {
        CompletedPart[] merged = new CompletedPart[this.expectedNumParts];
        for (int currPart = 1; currPart < this.expectedNumParts + 1; ++currPart) {
            CompletedPart completedPart;
            merged[currPart - 1] = completedPart = this.existingParts.containsKey(currPart) ? this.existingParts.get(currPart) : this.completedParts.get(currPart - 1);
        }
        return merged;
    }
}

