/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.util.Pool;
import org.eclipse.jetty.util.thread.AutoLock;

public class LockedPool<P>
extends Pool.Wrapper<P> {
    private final AutoLock lock = new AutoLock();
    private final Tracker<P> tracker;

    public LockedPool(Pool<P> pool) {
        this(pool, Tracker.noTracker());
    }

    public LockedPool(Pool<P> pool, Tracker<P> tracker) {
        super(pool);
        this.tracker = tracker;
    }

    @Override
    public Pool.Entry<P> reserve() {
        try (AutoLock ignored = this.lock.lock();){
            Pool.Entry entry = super.reserve();
            if (entry == null) {
                Pool.Entry<P> entry2 = null;
                return entry2;
            }
            LockedEntry lockedEntry = new LockedEntry(entry);
            return lockedEntry;
        }
    }

    @Override
    public Pool.Entry<P> acquire() {
        try (AutoLock ignored = this.lock.lock();){
            Pool.Entry entry = super.acquire();
            if (entry == null) {
                Pool.Entry<P> entry2 = null;
                return entry2;
            }
            LockedEntry lockedEntry = new LockedEntry(entry);
            this.tracker.acquired(this.getWrapped(), entry);
            LockedEntry lockedEntry2 = lockedEntry;
            return lockedEntry2;
        }
    }

    @Override
    public Pool.Entry<P> acquire(Function<Pool.Entry<P>, P> creator) {
        try (AutoLock ignored = this.lock.lock();){
            Pool.Entry<P> entry = super.acquire(creator);
            if (entry == null) {
                Pool.Entry<P> entry2 = null;
                return entry2;
            }
            LockedEntry lockedEntry = new LockedEntry(entry);
            this.tracker.acquired(this.getWrapped(), entry);
            LockedEntry lockedEntry2 = lockedEntry;
            return lockedEntry2;
        }
    }

    @Override
    public boolean isTerminated() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = super.isTerminated();
            return bl;
        }
    }

    @Override
    public Collection<Pool.Entry<P>> terminate() {
        try (AutoLock ignored = this.lock.lock();){
            Collection result = super.terminate();
            this.tracker.terminated(this.getWrapped(), result);
            Collection collection = result.stream().map(x$0 -> new LockedEntry(x$0)).collect(Collectors.toList());
            return collection;
        }
    }

    @Override
    public int size() {
        try (AutoLock ignored = this.lock.lock();){
            int n = super.size();
            return n;
        }
    }

    @Override
    public int getMaxSize() {
        try (AutoLock ignored = this.lock.lock();){
            int n = super.getMaxSize();
            return n;
        }
    }

    @Override
    public Stream<Pool.Entry<P>> stream() {
        try (AutoLock ignored = this.lock.lock();){
            Stream<Pool.Entry<P>> stream = super.stream().map(x$0 -> new LockedEntry(x$0));
            return stream;
        }
    }

    public static interface Tracker<T> {
        public static <S> Tracker<S> noTracker() {
            class NoTracker
            implements Tracker<S> {
                private static final Tracker<?> INSTANCE = new NoTracker();

                NoTracker() {
                }
            }
            return NoTracker.INSTANCE;
        }

        default public void acquired(Pool<T> pool, Pool.Entry<T> entry) {
        }

        default public void released(Pool<T> pool, Pool.Entry<T> entry) {
        }

        default public void removed(Pool<T> pool, Pool.Entry<T> entry) {
        }

        default public void terminated(Pool<T> pool, Collection<Pool.Entry<T>> entries) {
        }
    }

    private class LockedEntry
    extends Pool.Entry.Wrapper<P> {
        public LockedEntry(Pool.Entry<P> wrapped) {
            super(wrapped);
        }

        @Override
        public boolean release() {
            try (AutoLock ignored = LockedPool.this.lock.lock();){
                boolean released = super.release();
                if (released) {
                    LockedPool.this.tracker.released(LockedPool.this.getWrapped(), this.getWrapped());
                }
                boolean bl = released;
                return bl;
            }
        }

        @Override
        public boolean remove() {
            try (AutoLock ignored = LockedPool.this.lock.lock();){
                boolean removed = super.remove();
                if (removed) {
                    LockedPool.this.tracker.removed(LockedPool.this.getWrapped(), this.getWrapped());
                }
                boolean bl = removed;
                return bl;
            }
        }
    }

    public static interface Factory<F>
    extends Pool.Factory<F> {
        @Override
        default public Pool<F> wrap(Pool<F> pool) {
            return new LockedPool<F>(pool);
        }
    }
}

