/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Objects;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerServicesClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RequestConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentsEntity;
import org.apache.nifi.web.api.entity.ControllerServiceRunStatusEntity;
import org.apache.nifi.web.api.entity.PropertyDescriptorEntity;
import org.apache.nifi.web.api.entity.UpdateControllerServiceReferenceRequestEntity;
import org.apache.nifi.web.api.entity.VerifyConfigRequestEntity;

public class JerseyControllerServicesClient
extends AbstractJerseyClient
implements ControllerServicesClient {
    private final WebTarget controllerServicesTarget;
    private final WebTarget processGroupTarget;

    public JerseyControllerServicesClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyControllerServicesClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.controllerServicesTarget = baseTarget.path("/controller-services");
        this.processGroupTarget = baseTarget.path("/process-groups/{pgId}");
    }

    @Override
    public ControllerServiceEntity getControllerService(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Controller service id cannot be null");
        }
        return this.executeAction("Error retrieving status of controller service", () -> {
            WebTarget target = this.controllerServicesTarget.path("{id}").resolveTemplate("id", (Object)id);
            return (ControllerServiceEntity)this.getRequestBuilder(target).get(ControllerServiceEntity.class);
        });
    }

    @Override
    public ControllerServiceEntity activateControllerService(String id, ControllerServiceRunStatusEntity runStatusEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Controller service id cannot be null");
        }
        if (runStatusEntity == null) {
            throw new IllegalArgumentException("Entity cannnot be null");
        }
        return this.executeAction("Error enabling or disabling controller service", () -> {
            WebTarget target = this.controllerServicesTarget.path("{id}/run-status").resolveTemplate("id", (Object)id);
            return (ControllerServiceEntity)this.getRequestBuilder(target).put(Entity.entity((Object)runStatusEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ControllerServiceEntity.class);
        });
    }

    @Override
    public ControllerServiceEntity createControllerService(String parentGroupdId, ControllerServiceEntity controllerServiceEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)parentGroupdId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        if (controllerServiceEntity == null) {
            throw new IllegalArgumentException("Controller Service entity cannot be null");
        }
        return this.executeAction("Error creating Controller Service", () -> {
            WebTarget target = this.processGroupTarget.path("/controller-services").resolveTemplate("pgId", (Object)parentGroupdId);
            return (ControllerServiceEntity)this.getRequestBuilder(target).post(Entity.entity((Object)controllerServiceEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ControllerServiceEntity.class);
        });
    }

    @Override
    public ControllerServiceEntity updateControllerService(ControllerServiceEntity controllerServiceEntity) throws NiFiClientException, IOException {
        if (controllerServiceEntity == null) {
            throw new IllegalArgumentException("Controller Service entity cannot be null");
        }
        return this.executeAction("Error updating Controller Service", () -> {
            WebTarget target = this.controllerServicesTarget.path("/{id}").resolveTemplate("id", (Object)controllerServiceEntity.getId());
            return (ControllerServiceEntity)this.getRequestBuilder(target).put(Entity.entity((Object)controllerServiceEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ControllerServiceEntity.class);
        });
    }

    @Override
    public ControllerServiceEntity deleteControllerService(ControllerServiceEntity controllerServiceEntity) throws NiFiClientException, IOException {
        if (controllerServiceEntity == null) {
            throw new IllegalArgumentException("Controller Service entity cannot be null");
        }
        RevisionDTO revision = controllerServiceEntity.getRevision();
        if (revision == null) {
            throw new IllegalArgumentException("Controller Service Revision cannot be null");
        }
        return this.executeAction("Error deleting Controller Service", () -> {
            WebTarget target = this.controllerServicesTarget.path("/{id}").queryParam("version", new Object[]{revision.getVersion()}).queryParam("clientId", new Object[]{revision.getClientId()}).resolveTemplate("id", (Object)controllerServiceEntity.getId());
            if (controllerServiceEntity.isDisconnectedNodeAcknowledged() == Boolean.TRUE) {
                target = target.queryParam("disconnectedNodeAcknowledged", new Object[]{"true"});
            }
            return (ControllerServiceEntity)this.getRequestBuilder(target).delete(ControllerServiceEntity.class);
        });
    }

    @Override
    public ControllerServiceReferencingComponentsEntity getControllerServiceReferences(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Controller service id cannot be null");
        }
        return this.executeAction("Error retrieving Controller Service's referencing components", () -> {
            WebTarget target = this.controllerServicesTarget.path("{id}/references").resolveTemplate("id", (Object)id);
            return (ControllerServiceReferencingComponentsEntity)this.getRequestBuilder(target).get(ControllerServiceReferencingComponentsEntity.class);
        });
    }

    @Override
    public ControllerServiceReferencingComponentsEntity updateControllerServiceReferences(UpdateControllerServiceReferenceRequestEntity referencesEntity) throws NiFiClientException, IOException {
        if (referencesEntity == null) {
            throw new IllegalArgumentException("Controller Service references entity cannot be null");
        }
        return this.executeAction("Error updating Controller Service references", () -> {
            WebTarget target = this.controllerServicesTarget.path("/{id}/references").resolveTemplate("id", (Object)referencesEntity.getId());
            return (ControllerServiceReferencingComponentsEntity)this.getRequestBuilder(target).put(Entity.entity((Object)referencesEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ControllerServiceReferencingComponentsEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity submitConfigVerificationRequest(VerifyConfigRequestEntity configRequestEntity) throws NiFiClientException, IOException {
        if (configRequestEntity == null) {
            throw new IllegalArgumentException("Config Request Entity cannot be null");
        }
        if (configRequestEntity.getRequest() == null) {
            throw new IllegalArgumentException("Config Request DTO cannot be null");
        }
        if (configRequestEntity.getRequest().getComponentId() == null) {
            throw new IllegalArgumentException("Controller Service ID cannot be null");
        }
        if (configRequestEntity.getRequest().getProperties() == null) {
            throw new IllegalArgumentException("Controller Service properties cannot be null");
        }
        return this.executeAction("Error submitting Config Verification Request", () -> {
            WebTarget target = this.controllerServicesTarget.path("{id}/config/verification-requests").resolveTemplate("id", (Object)configRequestEntity.getRequest().getComponentId());
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)configRequestEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity getConfigVerificationRequest(String serviceId, String verificationRequestId) throws NiFiClientException, IOException {
        if (verificationRequestId == null) {
            throw new IllegalArgumentException("Verification Request ID cannot be null");
        }
        return this.executeAction("Error retrieving Config Verification Request", () -> {
            WebTarget target = this.controllerServicesTarget.path("{id}/config/verification-requests/{requestId}").resolveTemplate("id", (Object)serviceId).resolveTemplate("requestId", (Object)verificationRequestId);
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).get(VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity deleteConfigVerificationRequest(String serviceId, String verificationRequestId) throws NiFiClientException, IOException {
        if (verificationRequestId == null) {
            throw new IllegalArgumentException("Verification Request ID cannot be null");
        }
        return this.executeAction("Error deleting Config Verification Request", () -> {
            WebTarget target = this.controllerServicesTarget.path("{id}/config/verification-requests/{requestId}").resolveTemplate("id", (Object)serviceId).resolveTemplate("requestId", (Object)verificationRequestId);
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).delete(VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public PropertyDescriptorEntity getPropertyDescriptor(String serviceId, String propertyName, Boolean sensitive) throws NiFiClientException, IOException {
        Objects.requireNonNull(serviceId, "Service ID required");
        Objects.requireNonNull(propertyName, "Property Name required");
        return this.executeAction("Error retrieving Property Descriptor", () -> {
            WebTarget target = this.controllerServicesTarget.path("{id}/descriptors").resolveTemplate("id", (Object)serviceId).queryParam("propertyName", new Object[]{propertyName}).queryParam("sensitive", new Object[]{sensitive});
            return (PropertyDescriptorEntity)this.getRequestBuilder(target).get(PropertyDescriptorEntity.class);
        });
    }
}

