/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.persistent.AbstractPersistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.Persistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLong23TreeMap;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongMap;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongSet;
import org.jetbrains.annotations.Nullable;

public class PersistentLong23TreeSet
implements PersistentLongSet {
    private final Persistent23Tree<PersistentLongMap.Entry<Boolean>> set;

    public PersistentLong23TreeSet() {
        this(null);
    }

    private PersistentLong23TreeSet(@Nullable AbstractPersistent23Tree.RootNode<PersistentLongMap.Entry<Boolean>> root) {
        this.set = new Persistent23Tree<PersistentLongMap.Entry<Boolean>>(root);
    }

    @Override
    public PersistentLongSet.ImmutableSet beginRead() {
        return new ImmutableSet(this.set.getRoot());
    }

    @Override
    public PersistentLong23TreeSet getClone() {
        return new PersistentLong23TreeSet(this.set.getRoot());
    }

    @Override
    public PersistentLongSet.MutableSet beginWrite() {
        return new MutableSet(this.set);
    }

    protected static class IteratorImpl
    implements LongIterator {
        private final Iterator<PersistentLongMap.Entry<Boolean>> it;

        IteratorImpl(Iterator<PersistentLongMap.Entry<Boolean>> it) {
            this.it = it;
        }

        @Override
        public long nextLong() {
            PersistentLongMap.Entry<Boolean> entry = this.it.next();
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry.getKey();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Long next() {
            PersistentLongMap.Entry<Boolean> entry = this.it.next();
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry.getKey();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class MutableSet
    implements PersistentLongSet.MutableSet {
        private final PersistentLong23TreeMap.MutableMap<Boolean> map;

        MutableSet(Persistent23Tree<PersistentLongMap.Entry<Boolean>> set) {
            this.map = new PersistentLong23TreeMap.MutableMap(set);
        }

        @Override
        public LongIterator longIterator() {
            return new IteratorImpl(this.map.iterator());
        }

        @Override
        public LongIterator reverseLongIterator() {
            return new IteratorImpl(this.map.reverseIterator());
        }

        @Override
        public LongIterator tailLongIterator(long key) {
            return new IteratorImpl(this.map.tailEntryIterator(key));
        }

        @Override
        public LongIterator tailReverseLongIterator(long key) {
            return new IteratorImpl(this.map.tailReverseEntryIterator(key));
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean contains(long key) {
            return this.map.get(key) == Boolean.TRUE;
        }

        @Override
        public void add(long key) {
            this.map.put(key, Boolean.TRUE);
        }

        @Override
        public boolean remove(long key) {
            Boolean result = this.map.remove(key);
            if (result == null) {
                return false;
            }
            return result;
        }

        @Override
        public void clear() {
            this.map.setRoot(null);
        }

        @Override
        public boolean endWrite() {
            return this.map.endWrite();
        }
    }

    protected static class ImmutableSet
    extends PersistentLong23TreeMap.ImmutableMap<Boolean>
    implements PersistentLongSet.ImmutableSet {
        ImmutableSet(AbstractPersistent23Tree.RootNode<PersistentLongMap.Entry<Boolean>> root) {
            super(root);
        }

        @Override
        public boolean contains(long key) {
            return this.containsKey(key);
        }

        @Override
        public LongIterator longIterator() {
            return new IteratorImpl(this.iterator());
        }

        @Override
        public LongIterator reverseLongIterator() {
            return new IteratorImpl(this.reverseIterator());
        }

        @Override
        public LongIterator tailLongIterator(long key) {
            return new IteratorImpl(this.tailEntryIterator(key));
        }

        @Override
        public LongIterator tailReverseLongIterator(long key) {
            return new IteratorImpl(this.tailReverseEntryIterator(key));
        }
    }
}

