/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.Reopenable;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.griffin.engine.AbstractRedBlackTree;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.std.Misc;

public class LongTreeChain
extends AbstractRedBlackTree
implements Reopenable {
    private final TreeCursor cursor = new TreeCursor();
    private final MemoryARW valueChain;

    public LongTreeChain(long keyPageSize, int keyMaxPages, long valuePageSize, int valueMaxPages) {
        super(keyPageSize, keyMaxPages);
        this.valueChain = Vm.getARWInstance(valuePageSize, valueMaxPages, 6);
    }

    @Override
    public void clear() {
        super.clear();
        this.valueChain.jumpTo(0L);
    }

    @Override
    public void close() {
        super.close();
        Misc.free(this.valueChain);
        this.cursor.clear();
    }

    public TreeCursor getCursor() {
        this.cursor.toTop();
        return this.cursor;
    }

    public void put(Record leftRecord, RecordCursor sourceCursor, Record rightRecord, RecordComparator comparator) {
        int cmp;
        long parent;
        if (this.root == -1L) {
            this.putParent(leftRecord.getRowId());
            return;
        }
        comparator.setLeft(leftRecord);
        long p = this.root;
        do {
            parent = p;
            long r = LongTreeChain.refOf(p);
            sourceCursor.recordAt(rightRecord, this.valueChain.getLong(r));
            cmp = comparator.compare(rightRecord);
            if (cmp < 0) {
                p = LongTreeChain.leftOf(p);
                continue;
            }
            if (cmp > 0) {
                p = LongTreeChain.rightOf(p);
                continue;
            }
            LongTreeChain.setRef(p, this.appendValue(leftRecord.getRowId(), r));
            return;
        } while (p > -1L);
        p = this.allocateBlock();
        LongTreeChain.setParent(p, parent);
        LongTreeChain.setRef(p, this.appendValue(leftRecord.getRowId(), -1L));
        if (cmp < 0) {
            LongTreeChain.setLeft(parent, p);
        } else {
            LongTreeChain.setRight(parent, p);
        }
        this.fixInsert(p);
    }

    @Override
    public void reopen() {
    }

    private long appendValue(long value, long prevValueOffset) {
        long offset = this.valueChain.getAppendOffset();
        this.valueChain.putLong128(value, prevValueOffset);
        return offset;
    }

    @Override
    protected void putParent(long value) {
        this.root = this.allocateBlock();
        LongTreeChain.setRef(this.root, this.appendValue(value, -1L));
        LongTreeChain.setParent(this.root, -1L);
    }

    public class TreeCursor {
        private long chainCurrent;
        private long treeCurrent;

        public void clear() {
            this.treeCurrent = -1L;
            this.chainCurrent = -1L;
        }

        public boolean hasNext() {
            if (this.chainCurrent != -1L) {
                return true;
            }
            this.treeCurrent = LongTreeChain.successor(this.treeCurrent);
            if (this.treeCurrent == -1L) {
                return false;
            }
            this.chainCurrent = LongTreeChain.refOf(this.treeCurrent);
            return true;
        }

        public long next() {
            long result = this.chainCurrent;
            this.chainCurrent = LongTreeChain.this.valueChain.getLong(this.chainCurrent + 8L);
            return LongTreeChain.this.valueChain.getLong(result);
        }

        public void toTop() {
            this.setup();
        }

        private void setup() {
            long p = LongTreeChain.this.root;
            if (p != -1L) {
                while (LongTreeChain.leftOf(p) != -1L) {
                    p = LongTreeChain.leftOf(p);
                }
            }
            this.treeCurrent = p;
            this.chainCurrent = LongTreeChain.refOf(this.treeCurrent);
        }
    }
}

