/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class FileDigestUtils {
    private static final String DIGEST_ALGORITHM = "SHA-256";
    private static final int BUFFER_LENGTH = 4096;
    private static final int START_READ_INDEX = 0;
    private static final int STREAM_END_INDEX = -1;

    private FileDigestUtils() {
    }

    public static byte[] getDigest(File file) throws IOException {
        MessageDigest messageDigest = FileDigestUtils.getMessageDigest();
        byte[] buffer = new byte[4096];
        try (FileInputStream inputStream = new FileInputStream(file);){
            int bytesRead = ((InputStream)inputStream).read(buffer, 0, 4096);
            while (bytesRead > -1) {
                messageDigest.update(buffer);
                bytesRead = ((InputStream)inputStream).read(buffer, 0, 4096);
            }
        }
        return messageDigest.digest();
    }

    private static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(DIGEST_ALGORITHM, e);
        }
    }
}

