/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.output;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.output.MigrateErrorResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.internal.command.DbMigrate;

public class ErrorOutput
implements OperationResult {
    public ErrorOutputItem error;

    public ErrorOutput(ErrorCode errorCode, String message, String stackTrace) {
        this.error = new ErrorOutputItem(errorCode, message, stackTrace);
    }

    public static ErrorOutput fromException(Exception exception) {
        String message = exception.getMessage();
        if (exception instanceof FlywayException) {
            FlywayException flywayException = (FlywayException)exception;
            return new ErrorOutput(flywayException.getErrorCode(), message == null ? "Error occurred" : message, null);
        }
        return new ErrorOutput(ErrorCode.FAULT, message == null ? "Fault occurred" : message, ErrorOutput.getStackTrace(exception));
    }

    public static MigrateErrorResult fromMigrateException(DbMigrate.FlywayMigrateException exception) {
        return exception.getErrorResult();
    }

    private static String getStackTrace(Exception exception) {
        PrintStream printStream;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            printStream = new PrintStream((OutputStream)output, true, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
        exception.printStackTrace(printStream);
        return new String(output.toByteArray(), StandardCharsets.UTF_8);
    }

    public static class ErrorOutputItem {
        public ErrorCode errorCode;
        public String message;
        public String stackTrace;

        ErrorOutputItem(ErrorCode errorCode, String message, String stackTrace) {
            this.errorCode = errorCode;
            this.message = message;
            this.stackTrace = stackTrace;
        }
    }
}

