/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.implementation;

import com.azure.security.keyvault.keys.cryptography.implementation.Aes128Cbc;
import com.azure.security.keyvault.keys.cryptography.implementation.Aes128CbcHmacSha256;
import com.azure.security.keyvault.keys.cryptography.implementation.Aes128CbcPad;
import com.azure.security.keyvault.keys.cryptography.implementation.Aes128Kw;
import com.azure.security.keyvault.keys.cryptography.implementation.Aes192Cbc;
import com.azure.security.keyvault.keys.cryptography.implementation.Aes192CbcHmacSha384;
import com.azure.security.keyvault.keys.cryptography.implementation.Aes192CbcPad;
import com.azure.security.keyvault.keys.cryptography.implementation.Aes192Kw;
import com.azure.security.keyvault.keys.cryptography.implementation.Aes256Cbc;
import com.azure.security.keyvault.keys.cryptography.implementation.Aes256CbcHmacSha512;
import com.azure.security.keyvault.keys.cryptography.implementation.Aes256CbcPad;
import com.azure.security.keyvault.keys.cryptography.implementation.Aes256Kw;
import com.azure.security.keyvault.keys.cryptography.implementation.Algorithm;
import com.azure.security.keyvault.keys.cryptography.implementation.Es256;
import com.azure.security.keyvault.keys.cryptography.implementation.Es256k;
import com.azure.security.keyvault.keys.cryptography.implementation.Es384;
import com.azure.security.keyvault.keys.cryptography.implementation.Es512;
import com.azure.security.keyvault.keys.cryptography.implementation.Rsa15;
import com.azure.security.keyvault.keys.cryptography.implementation.RsaOaep;
import java.util.HashMap;
import java.util.Map;

final class AlgorithmResolver {
    static final AlgorithmResolver DEFAULT;
    private final Map<String, Algorithm> algorithms;

    private AlgorithmResolver(Map<String, Algorithm> algorithms) {
        this.algorithms = algorithms;
    }

    public Algorithm get(String algorithmName) {
        return this.algorithms.get(algorithmName);
    }

    static {
        HashMap<String, Algorithm> algorithms = new HashMap<String, Algorithm>();
        algorithms.put("A128CBC", new Aes128Cbc());
        algorithms.put("A192CBC", new Aes192Cbc());
        algorithms.put("A256CBC", new Aes256Cbc());
        algorithms.put("A128CBCPAD", new Aes128CbcPad());
        algorithms.put("A192CBCPAD", new Aes192CbcPad());
        algorithms.put("A256CBCPAD", new Aes256CbcPad());
        algorithms.put("A128CBC-HS256", new Aes128CbcHmacSha256());
        algorithms.put("A192CBC-HS384", new Aes192CbcHmacSha384());
        algorithms.put("A256CBC-HS512", new Aes256CbcHmacSha512());
        algorithms.put("A128KW", new Aes128Kw());
        algorithms.put("A192KW", new Aes192Kw());
        algorithms.put("A256KW", new Aes256Kw());
        algorithms.put("RSA1_5", new Rsa15());
        algorithms.put("RSA-OAEP", new RsaOaep());
        algorithms.put("ES256K", new Es256k());
        algorithms.put("ES256", new Es256());
        algorithms.put("ES384", new Es384());
        algorithms.put("ES512", new Es512());
        DEFAULT = new AlgorithmResolver(algorithms);
    }
}

