/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;

public class AuthorizationRequest {
    public static final String DEFAULT_EXPLANATION = "Unable to perform the desired action.";
    private final Resource resource;
    private final Resource requestedResource;
    private final String identity;
    private final Set<String> groups;
    private final RequestAction action;
    private final boolean isAccessAttempt;
    private final boolean isAnonymous;
    private final Map<String, String> userContext;
    private final Map<String, String> resourceContext;
    private final Supplier<String> explanationSupplier;

    private AuthorizationRequest(Builder builder) {
        Objects.requireNonNull(builder.resource, "The resource is required when creating an authorization request");
        Objects.requireNonNull(builder.action, "The action is required when creating an authorization request");
        Objects.requireNonNull(builder.isAccessAttempt, "Whether this request is an access attempt is request");
        Objects.requireNonNull(builder.isAnonymous, "Whether this request is being performed by an anonymous user is required");
        this.resource = builder.resource;
        this.identity = builder.identity;
        this.groups = builder.groups == null ? null : Collections.unmodifiableSet(builder.groups);
        this.action = builder.action;
        this.isAccessAttempt = builder.isAccessAttempt;
        this.isAnonymous = builder.isAnonymous;
        this.userContext = builder.userContext == null ? null : Collections.unmodifiableMap(builder.userContext);
        this.resourceContext = builder.resourceContext == null ? null : Collections.unmodifiableMap(builder.resourceContext);
        this.explanationSupplier = () -> {
            String explanation = (String)builder.explanationSupplier.get();
            if (explanation == null) {
                return DEFAULT_EXPLANATION;
            }
            return explanation;
        };
        this.requestedResource = builder.requestedResource == null ? builder.resource : builder.requestedResource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Resource getRequestedResource() {
        return this.requestedResource;
    }

    public String getIdentity() {
        return this.identity;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public boolean isAccessAttempt() {
        return this.isAccessAttempt;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public RequestAction getAction() {
        return this.action;
    }

    public Map<String, String> getUserContext() {
        return this.userContext;
    }

    public Map<String, String> getResourceContext() {
        return this.resourceContext;
    }

    public Supplier<String> getExplanationSupplier() {
        return this.explanationSupplier;
    }

    public static final class Builder {
        private Resource resource;
        private Resource requestedResource;
        private String identity;
        private Set<String> groups;
        private Boolean isAnonymous;
        private Boolean isAccessAttempt;
        private RequestAction action;
        private Map<String, String> userContext;
        private Map<String, String> resourceContext;
        private Supplier<String> explanationSupplier = () -> "Unable to perform the desired action.";

        public Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder requestedResource(Resource requestedResource) {
            this.requestedResource = requestedResource;
            return this;
        }

        public Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        public Builder anonymous(Boolean isAnonymous) {
            this.isAnonymous = isAnonymous;
            return this;
        }

        public Builder accessAttempt(Boolean isAccessAttempt) {
            this.isAccessAttempt = isAccessAttempt;
            return this;
        }

        public Builder action(RequestAction action) {
            this.action = action;
            return this;
        }

        public Builder userContext(Map<String, String> userContext) {
            if (userContext != null) {
                this.userContext = new HashMap<String, String>(userContext);
            }
            return this;
        }

        public Builder resourceContext(Map<String, String> resourceContext) {
            if (resourceContext != null) {
                this.resourceContext = new HashMap<String, String>(resourceContext);
            }
            return this;
        }

        public Builder explanationSupplier(Supplier<String> explanationSupplier) {
            if (explanationSupplier != null) {
                this.explanationSupplier = explanationSupplier;
            }
            return this;
        }

        public AuthorizationRequest build() {
            return new AuthorizationRequest(this);
        }
    }
}

