/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public enum KeyDerivationFunction {
    NONE("None", "The cipher is given a raw key conforming to the algorithm specifications"),
    NIFI_LEGACY("NiFi Legacy KDF", "MD5 @ 1000 iterations"),
    OPENSSL_EVP_BYTES_TO_KEY("OpenSSL EVP_BytesToKey", "Single iteration MD5 compatible with PKCS#5 v1.5"),
    BCRYPT("Bcrypt", "Bcrypt with configurable work factor. See Admin Guide"),
    SCRYPT("Scrypt", "Scrypt with configurable cost parameters. See Admin Guide"),
    PBKDF2("PBKDF2", "PBKDF2 with configurable hash function and iteration count. See Admin Guide"),
    ARGON2("Argon2", "Argon2 with configurable cost parameters. See Admin Guide.");

    private final String kdfName;
    private final String description;

    private KeyDerivationFunction(String kdfName, String description) {
        this.kdfName = kdfName;
        this.description = description;
    }

    public String getKdfName() {
        return this.kdfName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isStrongKDF() {
        return this.kdfName.equals(KeyDerivationFunction.BCRYPT.kdfName) || this.kdfName.equals(KeyDerivationFunction.SCRYPT.kdfName) || this.kdfName.equals(KeyDerivationFunction.PBKDF2.kdfName) || this.kdfName.equals(KeyDerivationFunction.ARGON2.kdfName);
    }

    public boolean hasFormattedSalt() {
        return this.kdfName.equals(KeyDerivationFunction.BCRYPT.kdfName) || this.kdfName.equals(KeyDerivationFunction.SCRYPT.kdfName) || this.kdfName.equals(KeyDerivationFunction.ARGON2.kdfName);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("KDF Name", (Object)this.kdfName);
        builder.append("Description", (Object)this.description);
        return builder.toString();
    }
}

