/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Sinkable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class HttpException
extends RuntimeException
implements Sinkable,
FlyweightMessageContainer {
    private static final ThreadLocal<HttpException> tlException = new ThreadLocal<HttpException>(HttpException::new);
    private final StringSink message = new StringSink();

    public static HttpException instance(CharSequence message) {
        HttpException ex = tlException.get();
        ex.message.clear();
        ex.message.put(message);
        return ex;
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return this.message.toString();
    }

    public HttpException put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public HttpException put(char c) {
        this.message.put(c);
        return this;
    }

    public HttpException put(int value) {
        this.message.put(value);
        return this;
    }

    public HttpException put(long value) {
        this.message.put(value);
        return this;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put(this.message);
    }
}

