/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.NanosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.tasks.TelemetryTask;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class TelemetryJob
extends SynchronizedJob
implements Closeable {
    public static final CharSequence configTableName = "telemetry_config";
    public static final CharSequence tableName = "telemetry";
    static final String OS_NAME = "os.name";
    static final String QDB_PACKAGE = "QDB_PACKAGE";
    private static final Log LOG = LogFactory.getLog(TelemetryJob.class);
    private static final String WRITER_LOCK_REASON = "telemetryJob";
    private final MicrosecondClock clock;
    private final CairoConfiguration configuration;
    private final RingQueue<TelemetryTask> queue;
    private final SCSequence subSeq;
    private final SCSequence tempSequence = new SCSequence();
    private TableWriter configWriter;
    private boolean enabled;
    private TableWriter writer;
    private final QueueConsumer<TelemetryTask> myConsumer = this::newRowConsumer;

    public TelemetryJob(CairoEngine engine) throws SqlException {
        this(engine, null);
    }

    public TelemetryJob(CairoEngine engine, @Nullable FunctionFactoryCache functionFactoryCache) throws SqlException {
        this.configuration = engine.getConfiguration();
        this.clock = this.configuration.getMicrosecondClock();
        this.enabled = this.configuration.getTelemetryConfiguration().getEnabled();
        this.queue = engine.getTelemetryQueue();
        this.subSeq = engine.getTelemetrySubSequence();
        try (SqlCompiler compiler = new SqlCompiler(engine, functionFactoryCache, null);){
            SqlExecutionContextImpl sqlExecutionContext = new SqlExecutionContextImpl(engine, 1);
            sqlExecutionContext.with(AllowAllCairoSecurityContext.INSTANCE, null, null);
            if (this.enabled) {
                compiler.compile("CREATE TABLE IF NOT EXISTS " + tableName + " (created timestamp, event short, origin short) timestamp(created)", sqlExecutionContext);
            }
            compiler.compile("CREATE TABLE IF NOT EXISTS " + configTableName + " (id long256, enabled boolean, version symbol, os symbol, package symbol)", sqlExecutionContext);
            this.tryAddColumn(compiler, sqlExecutionContext, "version symbol");
            this.tryAddColumn(compiler, sqlExecutionContext, "os symbol");
            this.tryAddColumn(compiler, sqlExecutionContext, "package symbol");
            if (this.enabled) {
                TableToken tableToken = engine.getTableToken(tableName);
                try {
                    this.writer = engine.getWriter(AllowAllCairoSecurityContext.INSTANCE, tableToken, WRITER_LOCK_REASON);
                }
                catch (CairoException ex) {
                    LOG.error().$("could not open [table=`").utf8(tableName).$("`, ex=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).$(']').$();
                    this.enabled = false;
                    if (compiler != null) {
                        if (var4_4 != null) {
                            try {
                                compiler.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            compiler.close();
                        }
                    }
                    return;
                }
            } else {
                this.writer = null;
            }
            try {
                TableToken configTableToken = engine.getTableToken(configTableName);
                this.configWriter = this.updateTelemetryConfig(compiler, sqlExecutionContext, this.enabled, configTableToken);
            }
            catch (CairoException ex) {
                this.writer = Misc.free(this.writer);
                LOG.error().$("could not open [table=`").utf8(configTableName).$("`, ex=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).$(']').$();
                this.enabled = false;
            }
            if (this.enabled) {
                this.newRow((short)100);
            }
        }
    }

    @Override
    public void close() {
        if (this.enabled) {
            this.runSerially();
            this.newRow((short)101);
            this.writer.commit();
            this.writer = Misc.free(this.writer);
        }
        this.configWriter = Misc.free(this.configWriter);
    }

    @Override
    public boolean runSerially() {
        if (this.enabled && this.subSeq.consumeAll(this.queue, this.myConsumer)) {
            this.writer.commit();
        }
        return false;
    }

    private void appendConfigRow(SqlCompiler compiler, TableWriter configWriter, Long256 id, boolean enabled) {
        TableWriter.Row row = configWriter.newRow();
        if (null == id) {
            MicrosecondClock clock = compiler.getEngine().getConfiguration().getMicrosecondClock();
            NanosecondClock nanosecondClock = compiler.getEngine().getConfiguration().getNanosecondClock();
            long a = nanosecondClock.getTicks();
            long b = clock.getTicks();
            row.putLong256(0, a, b, 0L, 0L);
            LOG.info().$("new instance [id=").$256(a, b, 0L, 0L).$(", enabled=").$(enabled).$(']').$();
        } else {
            row.putLong256(0, id);
        }
        row.putBool(1, enabled);
        row.putSym(2, this.configuration.getBuildInformation().getQuestDbVersion());
        row.putSym(3, System.getProperty(OS_NAME));
        String packageStr = System.getenv().get(QDB_PACKAGE);
        if (null != packageStr) {
            row.putSym(4, packageStr);
        }
        row.append();
        configWriter.commit();
    }

    private void newRow(short event) {
        if (this.enabled) {
            try {
                TableWriter.Row row = this.writer.newRow(this.clock.getTicks());
                row.putShort(1, event);
                row.putShort(2, (short)1);
                row.append();
            }
            catch (CairoException e) {
                LOG.error().$("Could not insert a new row in telemetry table [error=").$(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).$(']').$();
            }
        }
    }

    private void newRowConsumer(TelemetryTask telemetryRow) {
        try {
            TableWriter.Row row = this.writer.newRow(telemetryRow.created);
            row.putShort(1, telemetryRow.event);
            row.putShort(2, telemetryRow.origin);
            row.append();
        }
        catch (CairoException e) {
            LOG.error().$("Could not insert a new row in telemetry table [error=").$(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).$(']').$();
        }
    }

    private void tryAddColumn(SqlCompiler compiler, SqlExecutionContext executionContext, CharSequence columnDetails) {
        try {
            CompiledQuery cc = compiler.compile("ALTER TABLE " + configTableName + " ADD COLUMN " + columnDetails, executionContext);
            try (OperationFuture fut = cc.execute(this.tempSequence);){
                fut.await();
            }
        }
        catch (SqlException ex) {
            LOG.info().$("Failed to alter telemetry table [table=").$(configTableName).$(",error=").$(ex.getFlyweightMessage()).I$();
        }
    }

    private TableWriter updateTelemetryConfig(SqlCompiler compiler, SqlExecutionContextImpl sqlExecutionContext, boolean enabled, TableToken tableToken) throws SqlException {
        TableWriter configWriter = compiler.getEngine().getWriter(AllowAllCairoSecurityContext.INSTANCE, tableToken, WRITER_LOCK_REASON);
        CompiledQuery cc = compiler.compile(configTableName + " LIMIT -1", sqlExecutionContext);
        try (RecordCursorFactory factory = cc.getRecordCursorFactory();
             RecordCursor cursor = factory.getCursor(sqlExecutionContext);){
            if (cursor.hasNext()) {
                Record record = cursor.getRecord();
                boolean _enabled = record.getBool(1);
                Long256 l256 = record.getLong256A(0);
                CharSequence lastVersion = record.getSym(2);
                if (enabled != _enabled || !this.configuration.getBuildInformation().getQuestDbVersion().equals(lastVersion)) {
                    this.appendConfigRow(compiler, configWriter, l256, enabled);
                    LOG.advisory().$("instance config changes [id=").$256(l256.getLong0(), l256.getLong1(), 0L, 0L).$(", enabled=").$(enabled).$(']').$();
                } else {
                    LOG.advisory().$("instance [id=").$256(l256.getLong0(), l256.getLong1(), 0L, 0L).$(", enabled=").$(enabled).$(']').$();
                }
            } else {
                this.appendConfigRow(compiler, configWriter, null, enabled);
            }
        }
        return configWriter;
    }
}

