/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging;

import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.reporting.Severity;

public class FlowRegistryClientLogObserver
implements LogObserver {
    private final BulletinRepository bulletinRepository;
    private final FlowRegistryClientNode clientNode;

    public FlowRegistryClientLogObserver(BulletinRepository bulletinRepository, FlowRegistryClientNode clientNode) {
        this.bulletinRepository = bulletinRepository;
        this.clientNode = clientNode;
    }

    public void onLogMessage(LogMessage message) {
        String bulletinLevel = message.getLogLevel() == LogLevel.WARN ? Severity.WARNING.name() : message.getLogLevel().toString();
        Bulletin bulletin = BulletinFactory.createBulletin(null, (String)this.clientNode.getIdentifier(), (ComponentType)ComponentType.FLOW_REGISTRY_CLIENT, (String)this.clientNode.getName(), (String)"Log Message", (String)bulletinLevel, (String)message.getMessage());
        this.bulletinRepository.addBulletin(bulletin);
    }

    public String getComponentDescription() {
        return this.clientNode.toString();
    }
}

