/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.schema.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.nifi.minifi.commons.schema.RemotePortSchema;
import org.apache.nifi.minifi.commons.schema.RemoteProcessGroupSchema;
import org.apache.nifi.minifi.commons.schema.common.BaseSchema;
import org.apache.nifi.minifi.commons.schema.common.BaseSchemaWithIdAndName;
import org.apache.nifi.minifi.commons.schema.common.ConvertableSchema;

public class RemoteProcessGroupSchemaV2
extends BaseSchema
implements ConvertableSchema<RemoteProcessGroupSchema> {
    private BaseSchemaWithIdAndName idAndName;
    private String url;
    private List<RemotePortSchema> inputPorts;
    private String comment = "";
    private String timeout = "30 secs";
    private String yieldPeriod = "10 sec";
    private String transportProtocol = "RAW";

    public RemoteProcessGroupSchemaV2(Map map) {
        this.idAndName = new BaseSchemaWithIdAndName(map, "RemoteProcessGroup(id: {id}, name: {name})");
        String wrapperName = this.idAndName.getWrapperName();
        this.url = this.getRequiredKeyAsType(map, "url", String.class, wrapperName);
        this.inputPorts = this.convertListToType(this.getRequiredKeyAsType(map, "Input Ports", List.class, wrapperName), "input port", RemotePortSchema.class, "Input Ports");
        if (this.inputPorts != null) {
            for (RemotePortSchema remoteInputPortSchema : this.inputPorts) {
                this.addIssuesIfNotNull(remoteInputPortSchema);
            }
        }
        this.comment = this.getOptionalKeyAsType(map, "comment", String.class, wrapperName, "");
        this.timeout = this.getOptionalKeyAsType(map, "timeout", String.class, wrapperName, "30 secs");
        this.yieldPeriod = this.getOptionalKeyAsType(map, "yield period", String.class, wrapperName, "10 sec");
        this.transportProtocol = this.getOptionalKeyAsType(map, "transport protocol", String.class, wrapperName, "RAW");
        if (!RemoteProcessGroupSchema.TransportProtocolOptions.valid(this.transportProtocol)) {
            this.addValidationIssue("transport protocol", wrapperName, "it must be either 'RAW' or 'HTTP' but is '" + this.transportProtocol + "'");
        }
    }

    @Override
    public RemoteProcessGroupSchema convert() {
        Map<String, Object> result = this.idAndName.toMap();
        result.put("url", this.url);
        result.put("comment", this.comment);
        result.put("timeout", this.timeout);
        result.put("yield period", this.yieldPeriod);
        result.put("transport protocol", this.transportProtocol);
        RemoteProcessGroupSchemaV2.putListIfNotNull(result, "Input Ports", this.inputPorts);
        return new RemoteProcessGroupSchema(result);
    }

    @Override
    public List<String> getValidationIssues() {
        ArrayList<String> validationIssues = new ArrayList<String>(this.idAndName.getValidationIssues());
        validationIssues.addAll(super.getValidationIssues());
        return validationIssues;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public String getName() {
        return this.idAndName.getName();
    }

    public String getId() {
        return this.idAndName.getId();
    }

    public List<RemotePortSchema> getInputPorts() {
        return this.inputPorts;
    }
}

