/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.schema.serialization;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.nifi.minifi.commons.schema.ConfigSchema;
import org.apache.nifi.minifi.commons.schema.serialization.ConfigRepresenter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public class SchemaSaver {
    public static void saveConfigSchema(ConfigSchema configSchema, OutputStream output) throws IOException {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml((Representer)new ConfigRepresenter(), dumperOptions);
        Map<String, Object> yamlMap = configSchema.toMap();
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(output);){
            try {
                yaml.dump(yamlMap, (Writer)outputStreamWriter);
            }
            catch (YAMLException e) {
                throw new IOException(e);
            }
        }
    }
}

