/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIteratorBase;
import jetbrains.exodus.ExodusException;

public class CompoundByteIterable
extends ByteIterableBase {
    private final ByteIterable[] iterables;
    private final int count;

    public CompoundByteIterable(ByteIterable[] iterables) {
        this(iterables, iterables.length);
    }

    public CompoundByteIterable(ByteIterable[] iterables, int count) {
        if (count < 1) {
            throw new ExodusException("Failed to initialize CompoundByteIterable");
        }
        this.iterables = iterables;
        this.count = count;
    }

    @Override
    public int getLength() {
        int result = this.length;
        if (result == -1) {
            result = 0;
            for (int i = 0; i < this.count; ++i) {
                result += this.iterables[i].getLength();
            }
            this.length = result;
        }
        return result;
    }

    @Override
    protected ByteIterator getIterator() {
        return new CompoundByteIteratorBase(this.iterables[0].iterator()){
            int off;
            {
                this.off = 0;
            }

            @Override
            public ByteIterator nextIterator() {
                ++this.off;
                return this.off < CompoundByteIterable.this.count ? CompoundByteIterable.this.iterables[this.off].iterator() : null;
            }
        };
    }
}

