/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.dto;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.minifi.commons.schema.ProcessorSchema;
import org.apache.nifi.minifi.commons.schema.common.CollectionUtil;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RelationshipDTO;

public class ProcessorSchemaFunction
implements Function<ProcessorDTO, ProcessorSchema> {
    @Override
    public ProcessorSchema apply(ProcessorDTO processorDTO) {
        ProcessorConfigDTO processorDTOConfig = processorDTO.getConfig();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", processorDTO.getName());
        map.put("id", processorDTO.getId());
        map.put("class", processorDTO.getType());
        map.put("scheduling strategy", processorDTOConfig.getSchedulingStrategy());
        map.put("scheduling period", processorDTOConfig.getSchedulingPeriod());
        map.put("max concurrent tasks", processorDTOConfig.getConcurrentlySchedulableTaskCount());
        map.put("penalization period", processorDTOConfig.getPenaltyDuration());
        map.put("yield period", processorDTOConfig.getYieldDuration());
        Long runDurationMillis = processorDTOConfig.getRunDurationMillis();
        if (runDurationMillis != null) {
            map.put("run duration nanos", runDurationMillis * 1000L);
        }
        map.put("auto-terminated relationships list", CollectionUtil.nullToEmpty((List)processorDTO.getRelationships()).stream().filter(RelationshipDTO::isAutoTerminate).map(RelationshipDTO::getName).collect(Collectors.toList()));
        map.put("Properties", new HashMap(CollectionUtil.nullToEmpty((Map)processorDTOConfig.getProperties())));
        String annotationData = processorDTOConfig.getAnnotationData();
        if (annotationData != null && !annotationData.isEmpty()) {
            map.put("annotation data", annotationData);
        }
        return new ProcessorSchema(map);
    }
}

