/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.ServerConfiguration;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.metrics.HealthMetrics;
import io.questdb.mp.WorkerPool;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.ObjList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public abstract class WorkerPoolManager {
    private static final Log LOG = LogFactory.getLog(WorkerPoolManager.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CharSequenceObjHashMap<WorkerPool> dedicatedPools = new CharSequenceObjHashMap(4);
    private final AtomicBoolean running = new AtomicBoolean();
    private final WorkerPool sharedPool;

    public WorkerPoolManager(ServerConfiguration config, HealthMetrics metrics) {
        this.sharedPool = new WorkerPool(config.getWorkerPoolConfiguration(), metrics);
        this.configureSharedPool(this.sharedPool);
    }

    public WorkerPool getInstance(@NotNull WorkerPoolConfiguration config, @NotNull HealthMetrics metrics, @NotNull Requester requester) {
        if (this.running.get() || this.closed.get()) {
            throw new IllegalStateException("can only get instance before start");
        }
        if (config.getWorkerCount() < 1) {
            LOG.info().$("using SHARED pool [requester=").$((Object)requester).$(", workers=").$(this.sharedPool.getWorkerCount()).I$();
            return this.sharedPool;
        }
        String poolName = config.getPoolName();
        WorkerPool pool = this.dedicatedPools.get(poolName);
        if (pool == null) {
            pool = new WorkerPool(config, metrics);
            this.dedicatedPools.put(poolName, pool);
        }
        LOG.info().$("new DEDICATED pool [name=").$(poolName).$(", requester=").$((Object)requester).$(", workers=").$(pool.getWorkerCount()).I$();
        return pool;
    }

    public WorkerPool getSharedPool() {
        return this.sharedPool;
    }

    public int getSharedWorkerCount() {
        return this.sharedPool.getWorkerCount();
    }

    public void halt() {
        ObjList<CharSequence> poolNames = this.dedicatedPools.keys();
        int limit = poolNames.size();
        for (int i = 0; i < limit; ++i) {
            CharSequence name = poolNames.getQuick(i);
            WorkerPool pool = this.dedicatedPools.get(name);
            LOG.info().$("closing dedicated pool [name=").$(name).$(", workers=").$(pool.getWorkerCount()).I$();
            pool.halt();
        }
        this.dedicatedPools.clear();
        LOG.info().$("closing shared pool [name=").$(this.sharedPool.getPoolName()).$(", workers=").$(this.sharedPool.getWorkerCount()).I$();
        this.sharedPool.halt();
        this.closed.set(true);
    }

    public void start(Log sharedPoolLog) {
        if (this.running.compareAndSet(false, true)) {
            this.sharedPool.start(sharedPoolLog);
            LOG.info().$("started shared pool [name=").$(this.sharedPool.getPoolName()).$(", workers=").$(this.sharedPool.getWorkerCount()).I$();
            ObjList<CharSequence> poolNames = this.dedicatedPools.keys();
            int limit = poolNames.size();
            for (int i = 0; i < limit; ++i) {
                CharSequence name = poolNames.get(i);
                WorkerPool pool = this.dedicatedPools.get(name);
                pool.start(sharedPoolLog);
                LOG.info().$("started dedicated pool [name=").$(name).$(", workers=").$(pool.getWorkerCount()).I$();
            }
        }
    }

    protected abstract void configureSharedPool(WorkerPool var1);

    public static enum Requester {
        HTTP_SERVER("http"),
        HTTP_MIN_SERVER("min-http"),
        PG_WIRE_SERVER("pg-wire"),
        LINE_TCP_IO("line-tcp-io"),
        LINE_TCP_WRITER("line-tcp-writer"),
        OTHER("other"),
        WAL_APPLY("wal-apply");

        private final String requester;

        private Requester(String requester) {
            this.requester = requester;
        }

        public String toString() {
            return this.requester;
        }
    }
}

