/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spring.scope;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.spring.scope.JaxrsRequestAttributes;
import org.glassfish.jersey.server.spring.scope.JaxrsServletRequestAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.AbstractRequestAttributes;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Provider
@PreMatching
public final class RequestContextFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String REQUEST_ATTRIBUTES_PROPERTY = RequestContextFilter.class.getName() + ".REQUEST_ATTRIBUTES";
    private final SpringAttributeController attributeController;
    private static final SpringAttributeController EMPTY_ATTRIBUTE_CONTROLLER = new SpringAttributeController(){

        @Override
        public void setAttributes(ContainerRequestContext requestContext) {
        }

        @Override
        public void resetAttributes(ContainerRequestContext requestContext) {
        }
    };

    @Inject
    public RequestContextFilter(final InjectionManager injectionManager) {
        ApplicationContext appCtx = (ApplicationContext)injectionManager.getInstance(ApplicationContext.class);
        final boolean isWebApp = appCtx instanceof WebApplicationContext;
        this.attributeController = appCtx != null ? new SpringAttributeController(){

            @Override
            public void setAttributes(ContainerRequestContext requestContext) {
                Object attributes;
                if (isWebApp) {
                    HttpServletRequest httpRequest = (HttpServletRequest)injectionManager.getInstance(HttpServletRequest.class);
                    attributes = new JaxrsServletRequestAttributes(httpRequest, requestContext);
                } else {
                    attributes = new JaxrsRequestAttributes(requestContext);
                }
                requestContext.setProperty(REQUEST_ATTRIBUTES_PROPERTY, attributes);
                RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
            }

            @Override
            public void resetAttributes(ContainerRequestContext requestContext) {
                AbstractRequestAttributes attributes = (AbstractRequestAttributes)requestContext.getProperty(REQUEST_ATTRIBUTES_PROPERTY);
                RequestContextHolder.resetRequestAttributes();
                if (attributes != null) {
                    attributes.requestCompleted();
                }
            }
        } : EMPTY_ATTRIBUTE_CONTROLLER;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.attributeController.setAttributes(requestContext);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        this.attributeController.resetAttributes(requestContext);
    }

    private static interface SpringAttributeController {
        public void setAttributes(ContainerRequestContext var1);

        public void resetAttributes(ContainerRequestContext var1);
    }
}

