/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.controller.status.history.CounterMetricDescriptor;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.web.api.dto.status.StatusDescriptorDTO;
import org.apache.nifi.web.api.dto.status.StatusHistoryDTO;
import org.apache.nifi.web.api.dto.status.StatusSnapshotDTO;

public class StatusHistoryUtil {
    public static StatusHistoryDTO createStatusHistoryDTO(StatusHistory statusHistory) {
        ArrayList<StatusSnapshotDTO> snapshotDtos = new ArrayList<StatusSnapshotDTO>();
        LinkedHashSet metricDescriptors = new LinkedHashSet();
        LinkedHashMap componentDetails = new LinkedHashMap(statusHistory.getComponentDetails());
        HashSet metricNames = new HashSet();
        for (StatusSnapshot snapshot : statusHistory.getStatusSnapshots()) {
            StatusSnapshotDTO snapshotDto = StatusHistoryUtil.createStatusSnapshotDto(snapshot);
            snapshotDtos.add(snapshotDto);
            metricNames.addAll(snapshotDto.getStatusMetrics().keySet());
            metricDescriptors.addAll(snapshot.getMetricDescriptors());
        }
        for (StatusSnapshotDTO snapshotDto : snapshotDtos) {
            Map metrics = snapshotDto.getStatusMetrics();
            for (String metricName : metricNames) {
                if (metrics.containsKey(metricName)) continue;
                metrics.put(metricName, 0L);
            }
        }
        StatusHistoryDTO dto = new StatusHistoryDTO();
        dto.setGenerated(new Date());
        dto.setComponentDetails(componentDetails);
        dto.setFieldDescriptors(StatusHistoryUtil.createFieldDescriptorDtos(metricDescriptors));
        dto.setAggregateSnapshots(snapshotDtos);
        return dto;
    }

    public static StatusDescriptorDTO createStatusDescriptorDto(MetricDescriptor<?> metricDescriptor) {
        StatusDescriptorDTO dto = new StatusDescriptorDTO();
        dto.setDescription(metricDescriptor.getDescription());
        dto.setField(metricDescriptor.getField());
        dto.setFormatter(metricDescriptor.getFormatter().name());
        dto.setLabel(metricDescriptor.getLabel());
        return dto;
    }

    public static List<StatusDescriptorDTO> createFieldDescriptorDtos(Collection<MetricDescriptor<?>> metricDescriptors) {
        StatusDescriptorDTO[] standardMetricDescriptors = new StatusDescriptorDTO[metricDescriptors.size()];
        LinkedList<StatusDescriptorDTO> counterMetricDescriptors = new LinkedList<StatusDescriptorDTO>();
        for (MetricDescriptor<?> metricDescriptor : metricDescriptors) {
            if (metricDescriptor instanceof StandardMetricDescriptor) {
                standardMetricDescriptors[metricDescriptor.getMetricIdentifier()] = StatusHistoryUtil.createStatusDescriptorDto(metricDescriptor);
                continue;
            }
            if (metricDescriptor instanceof CounterMetricDescriptor) {
                counterMetricDescriptors.add(StatusHistoryUtil.createStatusDescriptorDto(metricDescriptor));
                continue;
            }
            throw new IllegalArgumentException("Unknown metric descriptor type: " + metricDescriptor.getClass().getName());
        }
        ArrayList<StatusDescriptorDTO> result = new ArrayList<StatusDescriptorDTO>(metricDescriptors.size());
        result.addAll(Arrays.asList(standardMetricDescriptors).stream().filter(i -> i != null).collect(Collectors.toList()));
        result.addAll(counterMetricDescriptors);
        return result;
    }

    public static List<StatusDescriptorDTO> createFieldDescriptorDtos(StatusHistory statusHistory) {
        ArrayList<StatusDescriptorDTO> dtos = new ArrayList<StatusDescriptorDTO>();
        LinkedHashSet allDescriptors = new LinkedHashSet();
        for (StatusSnapshot statusSnapshot : statusHistory.getStatusSnapshots()) {
            allDescriptors.addAll(statusSnapshot.getMetricDescriptors());
        }
        for (MetricDescriptor metricDescriptor : allDescriptors) {
            dtos.add(StatusHistoryUtil.createStatusDescriptorDto(metricDescriptor));
        }
        return dtos;
    }

    public static StatusSnapshotDTO createStatusSnapshotDto(StatusSnapshot statusSnapshot) {
        StatusSnapshotDTO dto = new StatusSnapshotDTO();
        dto.setTimestamp(statusSnapshot.getTimestamp());
        HashMap<String, Long> statusMetrics = new HashMap<String, Long>();
        for (MetricDescriptor descriptor : statusSnapshot.getMetricDescriptors()) {
            statusMetrics.put(descriptor.getField(), statusSnapshot.getStatusMetric(descriptor));
        }
        dto.setStatusMetrics(statusMetrics);
        return dto;
    }
}

