/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.flow.VersionedReportingTaskSnapshot;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.registry.flow.mapping.NiFiRegistryFlowMapper;

public class VersionedReportingTaskSnapshotMapper {
    private final NiFiRegistryFlowMapper flowMapper;
    private final ControllerServiceProvider controllerServiceProvider;

    public VersionedReportingTaskSnapshotMapper(ExtensionManager extensionManager, ControllerServiceProvider controllerServiceProvider) {
        this.flowMapper = new NiFiRegistryFlowMapper(extensionManager);
        this.controllerServiceProvider = controllerServiceProvider;
    }

    public VersionedReportingTaskSnapshot createMapping(Set<ReportingTaskNode> reportingTaskNodes, Set<ControllerServiceNode> controllerServiceNodes) {
        VersionedReportingTaskSnapshot versionedReportingTaskSnapshot = new VersionedReportingTaskSnapshot();
        versionedReportingTaskSnapshot.setReportingTasks(this.mapReportingTasks(reportingTaskNodes));
        versionedReportingTaskSnapshot.setControllerServices(this.mapControllerServices(controllerServiceNodes));
        return versionedReportingTaskSnapshot;
    }

    private List<VersionedReportingTask> mapReportingTasks(Set<ReportingTaskNode> reportingTaskNodes) {
        ArrayList<VersionedReportingTask> reportingTasks = new ArrayList<VersionedReportingTask>();
        for (ReportingTaskNode taskNode : reportingTaskNodes) {
            VersionedReportingTask versionedReportingTask = this.flowMapper.mapReportingTask(taskNode, this.controllerServiceProvider);
            reportingTasks.add(versionedReportingTask);
        }
        return reportingTasks;
    }

    private List<VersionedControllerService> mapControllerServices(Set<ControllerServiceNode> controllerServiceNodes) {
        ArrayList<VersionedControllerService> controllerServices = new ArrayList<VersionedControllerService>();
        for (ControllerServiceNode serviceNode : controllerServiceNodes) {
            VersionedControllerService versionedControllerService = this.flowMapper.mapControllerService(serviceNode, this.controllerServiceProvider, Collections.emptySet(), Collections.emptyMap());
            controllerServices.add(versionedControllerService);
        }
        return controllerServices;
    }
}

