/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.lifecycle.clientwindow;

/**
 * Configuration for the org.apache.myfaces.extensions.cdi.core.api.scope.conversation.WindowContext
 * - it's customizable via the Alternative or Specializes mechanism of CDI.
 */
public class WindowContextConfig
{
    protected WindowContextConfig()
    {
    }

    /**
     * Specifies if it is allowed to use URL params for forwarding the current window-id.
     * (deactivate it e.g. for higher security - in this case it's required to use a window id provided by a
     * component lib or a server-side window-handler)
     * 
     * @return true if it is allowed to add the window-id as URL parameter
     */
    public boolean isUrlParameterSupported()
    {
        return true;
    }

    /**
     * Allows to restrict window-ids.
     * <p>With the default window handler (esp. for JSF 1.2), URLs have to contain the window-id.
     * If users bookmark these links, they could open 2-n tabs (with the bookmark) which have the same window-id.
     * It is only possible to prevent it if the ClientSideWindowHandler is used.
     * </p>
     *
     * <p><b>ATTENTION:</b> Since CODI-1.0.6 this is set to <code>true</code> as defalt!</p>
     *
     * <p>
     * This must be enabled to:
     * </p>
     * <ul>
     *     <li>allow <i>target</i> attributes in a href</li>
     *     <li>support multiple webapps in an EAR scenario. Since each webapp has it's own session,
     *     they would otherwise trash their windowIds each time you link from one webapp to another one</li>
     *     <li>play nicely with other frameworks which use the window.name for browser tab detection</li>
     * </ul>
     * 
     * @return <code>true</code> to allow all windowIds already present in window.name.
     *         <code>false</code> to only allow window-ids which are generated by CODI
     */
    public boolean isUnknownWindowIdsAllowed()
    {
        return true;
    }

    /**
     * if set to <code>true</code> CODI will add a windowId=xxx parameter
     * while encoding each action URL.
     * @return true if the window-id should be added, false otherwise
     */
    public boolean isAddWindowIdToActionUrlsEnabled()
    {
        return false;
    }

    /**
     * Specifies the time for the timeout for a window. After a timeout is detected all beans which are only linked
     * to the window will be destroyed.
     *
     * @return the time for the timeout for a window
     */
    public int getWindowContextTimeoutInMinutes()
    {
        return 60;
    }

    /**
     * Restricts the number of active windows.
     *
     * @return limit for active windows
     */
    public int getMaxWindowContextCount()
    {
        return 64;
    }

    /**
     * Allows to activate the cleanup of empty window contexts to avoid cleanup e.g.
     * of the eldest window context instances if the max. count is reached.
     *
     * @return true for activating it, false otherwise
     */
    public boolean isCloseEmptyWindowContextsEnabled()
    {
        return false;
    }

    /**
     * Allows to restore the window-context before the component tree gets built.
     * 
     * @return true for activating it, false otherwise
     */
    public boolean isEagerWindowContextDetectionEnabled()
    {
        return true;
    }

    /*
     * event config
     */

    /**
     * Specifies if the
     * org.apache.myfaces.extensions.cdi.core.api.scope.conversation.event.CreateWindowContextEvent
     * will be fired.
     *
     * @return true if the event should be fired, false otherwise
     */
    public boolean isCreateWindowContextEventEnabled()
    {
        return false;
    }

    /**
     * Specifies if the
     * org.apache.myfaces.extensions.cdi.core.api.scope.conversation.event.CloseWindowContextEvent
     * will be fired.
     *
     * @return true if the event should be fired, false otherwise
     */
    public boolean isCloseWindowContextEventEnabled()
    {
        return false;
    }

    //boolean isResetWindowContextEventEnable();
}
