/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base;

import java.awt.Color;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.share.config.Configuration;
import org.apache.myfaces.trinidadinternal.share.data.ServletRequestParameters;
import org.apache.myfaces.trinidadinternal.share.url.EncoderUtils;
import org.apache.myfaces.trinidadinternal.share.util.FastMessageFormat;
import org.apache.myfaces.trinidadinternal.style.CoreStyle;
import org.apache.myfaces.trinidadinternal.style.PropertyParseException;
import org.apache.myfaces.trinidadinternal.ui.AttributeKey;
import org.apache.myfaces.trinidadinternal.ui.MutableUINode;
import org.apache.myfaces.trinidadinternal.ui.UIConstants;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.composite.PoppedAttributeBoundValue;
import org.apache.myfaces.trinidadinternal.ui.composite.RootAttributeBoundValue;
import org.apache.myfaces.trinidadinternal.ui.composite.RootChildBoundValue;
import org.apache.myfaces.trinidadinternal.ui.data.BoundValue;
import org.apache.myfaces.trinidadinternal.ui.data.bind.AndBoundValue;
import org.apache.myfaces.trinidadinternal.ui.data.bind.ComparisonBoundValue;
import org.apache.myfaces.trinidadinternal.ui.data.bind.DefaultingBoundValue;

@Deprecated
public class BaseLafUtils
implements UIConstants {
    public static final char CHAR_UNDEFINED = '\uffff';
    private static final Object _DOES_NOT_EXIST = new Object();
    private static final String _UNIQUE_ID_COUNT_PROPERTY = "idCount";
    private static final String _UNIQUE_ID_PREFIX = "M__Id";
    private static final Object _DEFAULT_RENDERING_PROPERTY_VALUE = null;
    private static final Object _STYLE_STACK_KEY = new Object();
    private static final String _BASE_DIRECTORY = "META-INF";
    private static final Random _STARTING_ID_COUNT = new Random();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(BaseLafUtils.class);

    public static String appendURLArgument(String baseURL, String key, String value) {
        return EncoderUtils.appendURLArguments(baseURL, new String[]{key, value});
    }

    public static String appendURLArguments(StringBuffer buffer, String baseURL, String[] keysAndValues) {
        return EncoderUtils.appendURLArguments(buffer, baseURL, keysAndValues);
    }

    public static String appendURLArguments(String baseURL, String[] keysAndValues) {
        return EncoderUtils.appendURLArguments(baseURL, keysAndValues);
    }

    public static String getStringAttributeValue(UIXRenderingContext context, UINode node, AttributeKey key) {
        Object attrValue = node.getAttributeValue(context, key);
        return attrValue != null ? attrValue.toString() : null;
    }

    public static String getParentFormName(UIXRenderingContext context) {
        return (String)context.getProperty("http://myfaces.apache.org/uix/ui", "formName");
    }

    public static boolean isRightToLeft(UIXRenderingContext context) {
        return context.getLocaleContext().isRightToLeft();
    }

    public static Object getTransformedID(UIXRenderingContext context, Object idObject, boolean isSubID) {
        if (idObject != null && isSubID) {
            return null;
        }
        return idObject;
    }

    public static UINode getRenderedAncestorByName(UIXRenderingContext context, UINode child, String namespaceURI, String name) {
        int ancestorCount = context.getRenderedAncestorNodeCount();
        for (int i = 1; i < ancestorCount; ++i) {
            UINode curr = context.getRenderedAncestorNode(i);
            if (namespaceURI != curr.getNamespaceURI() || !name.equals(curr.getLocalName())) continue;
            return curr;
        }
        return null;
    }

    public static void setRootBoundValue(MutableUINode node, AttributeKey attrKey) {
        node.setAttributeValue(attrKey, RootAttributeBoundValue.getBoundValue(attrKey));
    }

    public static Object getRenderingProperty(UIXRenderingContext context, Object key) {
        return context.getProperty("http://myfaces.apache.org/uix/ui", key);
    }

    public static Object getRenderingProperty(UIXRenderingContext context, Object key, Object defaultValue) {
        Object value = BaseLafUtils.getRenderingProperty(context, key);
        return value == null ? defaultValue : value;
    }

    public static void setRenderingProperty(UIXRenderingContext context, Object key, Object value) {
        context.setProperty("http://myfaces.apache.org/uix/ui", key, value);
    }

    public static void pushAttributeAsRenderingProperty(UIXRenderingContext context, UINode node, AttributeKey attrKey) {
        Object value = node.getAttributeValue(context, attrKey);
        BaseLafUtils.pushRenderingProperty(context, attrKey, value);
    }

    public static void pushAttributeAsStringRenderingProperty(UIXRenderingContext context, UINode node, AttributeKey attrKey) {
        Object value = node.getAttributeValue(context, attrKey);
        BaseLafUtils.pushRenderingProperty(context, attrKey, value != null ? value.toString() : null);
    }

    public static void pushRenderingProperty(UIXRenderingContext context, Object key, Object value) {
        BaseLafUtils.pushRenderingProperty(context, key, key, value);
    }

    public static void pushRenderingProperty(UIXRenderingContext context, Object key, Object localKey, Object value) {
        Object propertyValue = context.getProperty("http://myfaces.apache.org/uix/ui", key);
        if (propertyValue != _DEFAULT_RENDERING_PROPERTY_VALUE) {
            context.setLocalProperty(localKey, propertyValue);
        }
        BaseLafUtils.setRenderingProperty(context, key, value);
    }

    public static void popRenderingProperty(UIXRenderingContext context, Object key) {
        BaseLafUtils.popRenderingProperty(context, key, key);
    }

    public static void popRenderingProperty(UIXRenderingContext context, Object key, Object localKey) {
        Object value = context.getLocalProperty(0, localKey, _DEFAULT_RENDERING_PROPERTY_VALUE);
        context.setLocalProperty(localKey, null);
        BaseLafUtils.setRenderingProperty(context, key, value);
    }

    public static Object getLocalAttribute(UIXRenderingContext context, UINode node, AttributeKey attrKey) {
        Object result = context.getLocalProperty(0, attrKey, _DOES_NOT_EXIST);
        if (result == _DOES_NOT_EXIST) {
            result = node.getAttributeValue(context, attrKey);
            context.setLocalProperty(attrKey, result);
        }
        return result;
    }

    public static String getLocalTextAttribute(UIXRenderingContext context, UINode node, AttributeKey attrKey) {
        Object result = context.getLocalProperty(0, attrKey, _DOES_NOT_EXIST);
        if (result == _DOES_NOT_EXIST) {
            result = node.getAttributeValue(context, attrKey);
            if (result != null) {
                result = result instanceof Integer ? IntegerUtils.getString((int)((Integer)result)) : result.toString();
            }
            context.setLocalProperty(attrKey, result);
        }
        return (String)result;
    }

    public static boolean getLocalBooleanAttribute(UIXRenderingContext context, UINode node, AttributeKey attrKey, boolean defaultValue) {
        Object result = context.getLocalProperty(0, attrKey, _DOES_NOT_EXIST);
        if (result == _DOES_NOT_EXIST) {
            result = node.getAttributeValue(context, attrKey);
            if (result == null) {
                result = defaultValue ? Boolean.TRUE : Boolean.FALSE;
            }
            context.setLocalProperty(attrKey, result);
        }
        return Boolean.TRUE.equals(result);
    }

    public static UINode getLocalNamedChild(UIXRenderingContext context, UINode node, String childName) {
        Object result = context.getLocalProperty(0, childName, _DOES_NOT_EXIST);
        if (result == _DOES_NOT_EXIST) {
            UINode namedChild = node.getNamedChild(context, childName);
            context.setLocalProperty(childName, namedChild);
            return namedChild;
        }
        return (UINode)result;
    }

    public static int getLength(String[] strings) {
        int len = 0;
        int sz = strings.length;
        for (int i = 0; i < sz; ++i) {
            len += strings[i].length();
        }
        return len;
    }

    public static String generateUniqueID(UIXRenderingContext context) {
        int count;
        MutableInt countObj = (MutableInt)BaseLafUtils.getRenderingProperty(context, _UNIQUE_ID_COUNT_PROPERTY);
        if (countObj == null) {
            countObj = new MutableInt();
            count = BaseLafUtils._getUniqueIDStartingCount(context);
            context.setProperty("http://myfaces.apache.org/uix/ui", _UNIQUE_ID_COUNT_PROPERTY, countObj);
        } else {
            count = countObj.value;
        }
        countObj.value = count + 1;
        if (count == 0) {
            return _UNIQUE_ID_PREFIX;
        }
        StringBuffer buffer = new StringBuffer(_UNIQUE_ID_PREFIX.length() + 5);
        buffer.append(_UNIQUE_ID_PREFIX);
        BaseLafUtils._appendIntAsReversedChars(buffer, count);
        return new String(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int _getUniqueIDStartingCount(UIXRenderingContext context) {
        if ("portlet".equals(context.getRendererManager().getFacet()) || context.getPartialPageContext() != null) {
            Random random = _STARTING_ID_COUNT;
            synchronized (random) {
                return (Math.abs(_STARTING_ID_COUNT.nextInt() % 90) + 1) * 100;
            }
        }
        return 0;
    }

    public static char getCharacterAttr(UIXRenderingContext context, UINode node, AttributeKey key) {
        Object charObj = node.getAttributeValue(context, key);
        return BaseLafUtils.getCharacter(charObj);
    }

    public static char getCharacter(Object charObj) {
        String str;
        char ch = '\uffff';
        if (charObj instanceof Character) {
            ch = ((Character)charObj).charValue();
        } else if (charObj instanceof String && (str = (String)charObj).length() == 1) {
            ch = str.charAt(0);
        }
        return ch;
    }

    public static String getConfiguredURL(UIXRenderingContext context, Object directoryKey) {
        Configuration config = context.getConfiguration();
        String contextURI = (String)context.getProperty("http://myfaces.apache.org/uix/ui", UIXRenderingContext.CONTEXT_URI_PROPERTY);
        String baseURL = config.getURI(directoryKey, contextURI);
        if (context.isDesignTime()) {
            baseURL = BaseLafUtils._generateDesignTimeURL(context, baseURL);
        }
        return baseURL;
    }

    private static String _generateDesignTimeURL(UIXRenderingContext context, String baseURL) {
        String designTimeURL;
        boolean isJavascript;
        Configuration configInfo = context.getConfiguration();
        ExternalContext external = context.getFacesContext().getExternalContext();
        String contextURI = external.getRequestContextPath();
        boolean bl = isJavascript = baseURL.indexOf((String)Configuration.JSLIBS_DIRECTORY) != -1;
        if (!(baseURL.equals(configInfo.getURI(Configuration.IMAGES_CACHE_DIRECTORY, contextURI)) || baseURL.equals(configInfo.getURI(Configuration.STYLES_CACHE_DIRECTORY, contextURI)) || isJavascript)) {
            designTimeURL = ClassLoaderUtils.getResource((String)(_BASE_DIRECTORY + baseURL)).toString();
        } else {
            Map appMap = external.getApplicationMap();
            if (appMap.get("javax.servlet.context.tempdir") == null) {
                String resourceDirectoryPath = baseURL.substring(baseURL.indexOf(47) + 1);
                String tempCacheDirectory = System.getProperty("java.io.tmpdir");
                designTimeURL = "file:" + File.separator + tempCacheDirectory + resourceDirectoryPath;
            } else {
                String resourceDirectoryPath = baseURL;
                String tempCacheDirectory = ((File)appMap.get("javax.servlet.context.tempdir")).getAbsolutePath();
                designTimeURL = tempCacheDirectory + resourceDirectoryPath;
            }
        }
        return designTimeURL;
    }

    public static BoundValue createIsRenderedBoundValue(String childName) {
        return BaseLafUtils.createIsRenderedBoundValue(RootChildBoundValue.getBoundValue(childName));
    }

    public static BoundValue createIsRenderedBoundValue(BoundValue targetUINodeValue) {
        return new AndBoundValue(ComparisonBoundValue.createExistsValue(targetUINodeValue), new DefaultingBoundValue((BoundValue)new PoppedAttributeBoundValue(targetUINodeValue, RENDERED_ATTR), Boolean.TRUE));
    }

    protected BaseLafUtils() {
    }

    private static void _appendIntAsReversedChars(StringBuffer buffer, int count) {
        if (count < 0) {
            buffer.append('_');
            count = -count;
        }
        while (count > 0) {
            buffer.append((char)(97 + --count % 26));
            count /= 26;
        }
    }

    public static int getKeyValueArraySize(Object[] keyValues, int perPairOverhead) {
        if (keyValues == null) {
            return 0;
        }
        int keyValueCount = keyValues.length;
        if (keyValueCount == 0) {
            return 0;
        }
        if (keyValueCount % 2 != 0) {
            throw new IllegalArgumentException("unequal key/value count");
        }
        if (keyValues instanceof String[]) {
            String[] keyValueStrings = (String[])keyValues;
            int keyValueSize = 0;
            for (int i = 0; i < keyValueCount; i += 2) {
                String key = keyValueStrings[i];
                if (key == null) continue;
                keyValueSize += key.length();
                String value = keyValueStrings[i + 1];
                if (value == null) continue;
                keyValueSize += value.length();
            }
            return keyValueSize += perPairOverhead * keyValueCount;
        }
        return keyValues.length * 13;
    }

    public static String encodeCompoundKeyValues(Object[] keyValues) {
        int keyValueSize = BaseLafUtils.getKeyValueArraySize(keyValues, 3);
        if (keyValueSize > 0) {
            if (keyValues != null) {
                return ServletRequestParameters.encodeCompoundKeyValues(Arrays.asList(keyValues).iterator(), keyValueSize);
            }
            return ServletRequestParameters.encodeCompoundKeyValues(Collections.EMPTY_LIST.iterator(), keyValueSize);
        }
        return null;
    }

    public static String encodeCompoundKeyValues(Object[] keyValues, Object[] keyExchanges) {
        int keyValueSize = BaseLafUtils.getKeyValueArraySize(keyValues, 3);
        int keyExchangesSize = BaseLafUtils.getKeyValueArraySize(keyExchanges, 3);
        if (keyValueSize > 0 || keyExchangesSize > 0) {
            if (keyValues == null) {
                keyValues = new Object[]{};
            }
            if (keyExchanges == null) {
                keyExchanges = new Object[]{};
            }
            return ServletRequestParameters.encodeCompoundKeyValues(Arrays.asList(keyValues).iterator(), keyValueSize, Arrays.asList(keyExchanges).iterator(), keyExchangesSize);
        }
        return null;
    }

    public static String getOutputEncoding(UIXRenderingContext context) {
        return context.getFacesContext().getResponseWriter().getCharacterEncoding();
    }

    public static String getFormattedString(UIXRenderingContext context, String pattern, String[] parameters) {
        FastMessageFormat formatter = (FastMessageFormat)((Object)context.getProperty("http://myfaces.apache.org/uix/ui", pattern));
        if (formatter == null) {
            formatter = new FastMessageFormat(pattern);
            context.setProperty("http://myfaces.apache.org/uix/ui", pattern, (Object)formatter);
        }
        return formatter.format(parameters);
    }

    public static void pushStyleAttrs(UIXRenderingContext context, String styleClass, CoreStyle inlineStyle) {
        BaseLafUtils._getStyleStack(context).push(styleClass, inlineStyle);
    }

    public static void popStyleAttrs(UIXRenderingContext context) {
        BaseLafUtils._getStyleStack(context).pop();
    }

    public static Color getBackgroundColor(UIXRenderingContext context) {
        return BaseLafUtils._getStyleStack(context).getBackgroundColor(context);
    }

    private static StyleStack _getStyleStack(UIXRenderingContext context) {
        StyleStack stack = (StyleStack)BaseLafUtils.getRenderingProperty(context, _STYLE_STACK_KEY);
        if (stack == null) {
            stack = new StyleStack();
            stack.push("af|body", null);
            BaseLafUtils.setRenderingProperty(context, _STYLE_STACK_KEY, stack);
        }
        return stack;
    }

    public static Object getComponentLabel(UIComponent component) {
        Object o = component.getAttributes().get("label");
        return o;
    }

    private static class StyleStack {
        private Entry _top;

        private StyleStack() {
        }

        public void push(String styleClass, CoreStyle inlineStyle) {
            this._top = new Entry(styleClass, inlineStyle, this._top);
        }

        public void pop() {
            assert (this._top != null);
            Entry oldTop = this._top;
            this._top = this._top.next;
            oldTop.next = null;
        }

        public Color getBackgroundColor(UIXRenderingContext context) {
            if (this._top != null && this._top.background != null) {
                return this._top.background;
            }
            Entry entry = this._top;
            while (entry != null) {
                Color background = entry.background;
                if (background != null || (background = StyleStack._resolveBackground(context, entry)) != null) {
                    entry = this._top;
                    while (entry != null && entry.background == null) {
                        entry.background = background;
                        entry = entry.next;
                    }
                    return background;
                }
                entry = entry.next;
            }
            return null;
        }

        private static Color _resolveBackground(UIXRenderingContext context, Entry entry) {
            Color background = StyleStack._getBackground(entry.inlineStyle);
            if (background != null || entry.styleClass != null) {
                // empty if block
            }
            entry.background = background;
            _LOG.fine("Could not find background color");
            return background;
        }

        private static Color _getBackground(CoreStyle style) {
            if (style != null) {
                try {
                    return (Color)style.getParsedProperty(CoreStyle.BACKGROUND_KEY);
                }
                catch (PropertyParseException propertyParseException) {
                    // empty catch block
                }
            }
            return null;
        }

        private static class Entry {
            public final String styleClass;
            public final CoreStyle inlineStyle;
            public Color background;
            public Entry next;

            public Entry(String styleClass, CoreStyle inlineStyle, Entry next) {
                this.styleClass = styleClass;
                this.inlineStyle = inlineStyle;
                this.next = next;
            }

            private Entry() {
                this(null, null, null);
                assert (false);
            }
        }
    }

    private static final class MutableInt {
        public int value;

        private MutableInt() {
        }
    }
}

