/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.pregen.variant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.SkinVariantExtractor;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;

final class PlatformVariantExtractor
implements SkinVariantExtractor<Integer> {
    private final Collection<Integer> _platforms = new HashSet<Integer>();

    @Override
    public void visit(StyleSheetNode node) {
        Collection<Integer> nodePlatforms = node.getPlatforms();
        for (Integer platform : nodePlatforms) {
            this._platforms.add(platform);
        }
    }

    @Override
    public List<Integer> getVariants() {
        ArrayList<Integer> platforms = new ArrayList<Integer>(this._platforms.size() + 1);
        if (!this._platforms.contains(0)) {
            platforms.add(0);
        }
        platforms.addAll(this._platforms);
        PlatformVariantExtractor._sortByPlatformName(platforms);
        return platforms;
    }

    private static void _sortByPlatformName(List<Integer> platforms) {
        Collections.sort(platforms, new Comparator<Integer>(){

            @Override
            public int compare(Integer platform1, Integer platform2) {
                String name1 = NameUtils.getPlatformName(platform1);
                String name2 = NameUtils.getPlatformName(platform2);
                assert (name1 != null);
                assert (name2 != null);
                return name1.compareTo(name2);
            }
        });
    }
}

