/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXSingleStep;
import org.apache.myfaces.trinidad.component.core.nav.CoreSingleStepButtonBar;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.CommandButtonRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SelectRangeChoiceBarRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.util.nls.StringUtils;

public class SingleStepButtonBarRenderer
extends XhtmlRenderer {
    private PropertyKey _selectedStepKey;
    private PropertyKey _maxStepKey;
    private PropertyKey _textKey;
    private Button _nextButton;
    private Button _backButton;
    private static final String _SINGLE_BACK_TEXT_KEY = "af_singleStepButtonBar.BACK";
    private static final String _SINGLE_NEXT_TEXT_KEY = "af_singleStepButtonBar.NEXT";
    private static final String _SINGLE_CONTINUE_TEXT_KEY = "af_singleStepButtonBar.CONTINUE";
    private static final String _SINGLE_RANGE_FORMAT_TOTAL_STRING = "af_singleStepButtonBar.FORMAT_TOTAL";
    private static final String _SINGLE_RANGE_FORMAT_NO_TOTAL_STRING = "af_singleStepButtonBar.FORMAT_NO_TOTAL";
    private static final String _STEP_TEXT_KEY = "af_singleStepButtonBar.STEP";
    private static final String _NEXT_ID_SUFFIX = "::next";
    private static final String _BACK_ID_SUFFIX = "::back";
    private static final long _MAX_VALUE_UNKNOWN = ((Number)UIXSingleStep.MAX_STEP_KEY.getDefault()).longValue();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SingleStepButtonBarRenderer.class);

    public SingleStepButtonBarRenderer() {
        super(CoreSingleStepButtonBar.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._selectedStepKey = type.findKey("selectedStep");
        this._maxStepKey = type.findKey("maxStep");
        this._textKey = type.findKey("text");
        this._backButton = new Button(type, false);
        this._nextButton = new Button(type, true);
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        String id;
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        String source = (String)parameters.get("source");
        String string = id = clientId == null ? this.getClientId(facesContext, component) : clientId;
        if (source != null && source.startsWith(id)) {
            String suffix = source.substring(id.length());
            UIXSingleStep singleStep = (UIXSingleStep)component;
            if (suffix.equals(_NEXT_ID_SUFFIX)) {
                singleStep.setActionType(UIXSingleStep.NEXT_ACTION_TYPE);
            } else if (suffix.equals(_BACK_ID_SUFFIX)) {
                singleStep.setActionType(UIXSingleStep.PREVIOUS_ACTION_TYPE);
            } else {
                return;
            }
            new ActionEvent(component).queue();
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected String getDefaultStyleClass(UIComponent component, FacesBean bean) {
        return "af|singleStepButtonBar";
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        boolean showNextButton;
        if (this.canSkipRendering(context, rc, component)) {
            return;
        }
        long currentValue = this.getSelectedStep(component, bean);
        long totalItems = this.getMaxStep(component, bean);
        boolean showBackButton = currentValue > 1L;
        boolean bl = showNextButton = totalItems == _MAX_VALUE_UNKNOWN || currentValue < totalItems;
        if (!showBackButton && !showNextButton || currentValue > totalItems && totalItems != _MAX_VALUE_UNKNOWN || currentValue < _MAX_VALUE_UNKNOWN) {
            return;
        }
        String formName = rc.getFormData().getName();
        if (formName == null) {
            _LOG.warning("SINGLE_STEP_MUST_INSIDE_FORM");
            return;
        }
        if (!SingleStepButtonBarRenderer.supportsNavigation(rc)) {
            return;
        }
        boolean renderAsTable = SelectRangeChoiceBarRenderer.__renderAsTable(component);
        ResponseWriter writer = context.getResponseWriter();
        if (renderAsTable) {
            writer.startElement("table", component);
            this.renderAllAttributes(context, rc, component, bean);
            this.renderId(context, component);
            OutputUtils.renderLayoutTableAttributes(context, rc, "0", null);
            writer.startElement("tr", null);
        }
        writer.startElement("td", null);
        if (showBackButton) {
            this.delegateRenderer(context, rc, component, bean, this._backButton);
            writer.endElement("td");
            this._renderSpacerCell(context, rc);
            writer.startElement("td", null);
        }
        writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        if (totalItems > 2L) {
            String rangeString = this._getRangeString(rc, component, bean, currentValue, totalItems);
            writer.startElement("span", null);
            SingleStepButtonBarRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|singleStepButtonBar::label");
            writer.writeText((Object)rangeString, "text");
            writer.endElement("span");
        }
        if (showNextButton) {
            writer.endElement("td");
            this._renderSpacerCell(context, rc);
            writer.startElement("td", null);
            this.delegateRenderer(context, rc, component, bean, this._nextButton);
        }
        writer.endElement("td");
        if (renderAsTable) {
            writer.endElement("tr");
            writer.endElement("table");
        }
    }

    protected long getSelectedStep(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._selectedStepKey);
        if (o == null) {
            o = this._selectedStepKey.getDefault();
        }
        return SingleStepButtonBarRenderer.toLong((Object)o);
    }

    protected long getMaxStep(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._maxStepKey);
        if (o == null) {
            o = this._maxStepKey.getDefault();
        }
        return SingleStepButtonBarRenderer.toLong((Object)o);
    }

    protected String getText(UIComponent component, FacesBean bean) {
        return SingleStepButtonBarRenderer.toString((Object)bean.getProperty(this._textKey));
    }

    protected void renderItemSpacer(FacesContext context, RenderingContext rc) throws IOException {
        if (SingleStepButtonBarRenderer.isPDA((RenderingContext)rc)) {
            context.getResponseWriter().writeText((Object)XhtmlConstants.NBSP_STRING, null);
        } else {
            this.renderSpacer(context, rc, "5", "1");
        }
    }

    private void _renderSpacerCell(FacesContext context, RenderingContext rc) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        this.renderItemSpacer(context, rc);
        writer.endElement("td");
    }

    private String _getRangeString(RenderingContext rc, UIComponent component, FacesBean bean, long start, long total) {
        String[] parameters;
        String pattern;
        String text = this.getText(component, bean);
        if (text == null) {
            text = rc.getTranslatedString(_STEP_TEXT_KEY);
        }
        if (total == _MAX_VALUE_UNKNOWN) {
            pattern = rc.getTranslatedString(_SINGLE_RANGE_FORMAT_NO_TOTAL_STRING);
            parameters = new String[]{text, IntegerUtils.getString((long)start)};
        } else {
            pattern = rc.getTranslatedString(_SINGLE_RANGE_FORMAT_TOTAL_STRING);
            parameters = new String[]{text, IntegerUtils.getString((long)start), IntegerUtils.getString((long)total)};
        }
        return XhtmlUtils.getFormattedString(pattern, parameters);
    }

    private static class Button
    extends CommandButtonRenderer {
        private boolean _next;

        public Button(FacesBean.Type type, boolean next) {
            super(type);
            this._next = next;
        }

        protected String getClientId(FacesContext context, UIComponent component) {
            String clientId = super.getClientId(context, component);
            return clientId + (this._next ? SingleStepButtonBarRenderer._NEXT_ID_SUFFIX : SingleStepButtonBarRenderer._BACK_ID_SUFFIX);
        }

        @Override
        protected String getShortDesc(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected String getStyleClass(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected String getInlineStyle(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected String getText(UIComponent component, FacesBean bean) {
            String textAndAccessKey = this._getTextAndAccessKey();
            return StringUtils.stripMnemonic(textAndAccessKey);
        }

        @Override
        protected char getAccessKey(UIComponent component, FacesBean bean) {
            String textAndAccessKey = this._getTextAndAccessKey();
            int index = StringUtils.getMnemonicIndex(textAndAccessKey);
            if (index < 0) {
                return '\u0000';
            }
            return textAndAccessKey.charAt(index + 1);
        }

        @Override
        protected void renderEventHandlers(FacesContext context, UIComponent component, FacesBean bean) throws IOException {
            context.getResponseWriter().writeAttribute("onclick", (Object)this.getOnclick(component, bean), null);
        }

        @Override
        protected String getComponentOnclick(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected boolean getImmediate(UIComponent component, FacesBean bean) {
            return !this._next;
        }

        @Override
        protected boolean getPartialSubmit(UIComponent component, FacesBean bean) {
            return false;
        }

        @Override
        protected boolean getDisabled(UIComponent component, FacesBean bean) {
            return false;
        }

        @Override
        protected String getIcon(UIComponent component, FacesBean bean) {
            return null;
        }

        private String _getTextAndAccessKey() {
            RenderingContext rc = RenderingContext.getCurrentInstance();
            return rc.getTranslatedString(this._next ? SingleStepButtonBarRenderer._SINGLE_NEXT_TEXT_KEY : SingleStepButtonBarRenderer._SINGLE_BACK_TEXT_KEY);
        }
    }
}

