/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.el;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidadinternal.el.SecondaryWindowHelpProvider;

public class OracleHelpProvider
extends SecondaryWindowHelpProvider {
    private static final String _TOPIC_PARAM = "topic";
    private static final String _LOCALE_PARAM = "locale";
    private String _defaultOHWServletLocation = null;
    private ConcurrentHashMap<Locale, String> _localeSpecificServlets = null;

    public OracleHelpProvider(String ohwServletLocation) {
        if (ohwServletLocation != null && ohwServletLocation.endsWith("//")) {
            ohwServletLocation = ohwServletLocation.substring(0, ohwServletLocation.length() - 1);
        }
        this._defaultOHWServletLocation = ohwServletLocation;
        this._localeSpecificServlets = new ConcurrentHashMap(13);
    }

    public void registerLocaleSpecificServlet(Locale locale, String localeSpecificServletLocation) {
        if (locale != null && localeSpecificServletLocation != null) {
            this._localeSpecificServlets.put(locale, localeSpecificServletLocation);
        }
    }

    protected String getHelpTopicURL(Object key) {
        String helpURL = null;
        if (key != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            Locale locale = context.getViewRoot().getLocale();
            String servletLocation = this._getLocaleSpecificServlet(context);
            boolean hasQueryParams = servletLocation.indexOf(63) >= 0;
            helpURL = servletLocation + (hasQueryParams ? "&" : "?") + _TOPIC_PARAM + "=" + key.toString() + "&" + _LOCALE_PARAM + "=" + locale.toString();
        }
        return helpURL;
    }

    protected String getHelpSystemURL(Object key) {
        if ("frontPage".equals(key)) {
            FacesContext context = FacesContext.getCurrentInstance();
            Locale locale = context.getViewRoot().getLocale();
            String servletLocation = this._getLocaleSpecificServlet(context);
            if (servletLocation != null) {
                boolean hasQueryParams = servletLocation.indexOf(63) >= 0;
                servletLocation = servletLocation + (hasQueryParams ? "&" : "?") + _LOCALE_PARAM + "=" + locale.toString();
            }
            return servletLocation;
        }
        return null;
    }

    private String _getLocaleSpecificServlet(FacesContext context) {
        String servletLocation = this._defaultOHWServletLocation;
        Locale desiredLocale = context.getViewRoot().getLocale();
        Locale matchingLocale = null;
        if (this._localeSpecificServlets.containsKey(desiredLocale)) {
            servletLocation = this._localeSpecificServlets.get(desiredLocale);
        } else {
            Locale langCountryOnly = new Locale(desiredLocale.getLanguage(), desiredLocale.getCountry());
            if (this._localeSpecificServlets.containsKey(langCountryOnly)) {
                matchingLocale = langCountryOnly;
            } else {
                Locale langOnly = new Locale(desiredLocale.getLanguage(), "");
                if (this._localeSpecificServlets.containsKey(langOnly)) {
                    matchingLocale = langOnly;
                }
            }
            if (matchingLocale != null) {
                servletLocation = this._localeSpecificServlets.get(matchingLocale);
            }
            if (servletLocation != null) {
                this._localeSpecificServlets.put(desiredLocale, servletLocation);
            }
        }
        return servletLocation;
    }
}

