/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.picklist;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.commons.collections.CollectionUtils;
import org.apache.myfaces.custom.picklist.HtmlSelectManyPicklist;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlListboxRendererBase;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlPicklistRenderer
extends HtmlListboxRendererBase {
    private static final String FUNCTION_ADD_TO_SELECTED = "myfaces_picklist_addToSelected";
    private static final String FUNCTION_ADD_ALL_TO_SELECTED = "myfaces_picklist_addAllToSelected";
    private static final String FUNCTION_REMOVE_FROM_SELECTED = "myfaces_picklist_removeFromSelected";
    private static final String FUNCTION_REMOVE_ALL_FROM_SELECTED = "myfaces_picklist_removeAllFromSelected";
    private static final String AVAILABLE_SUFFIX = "_AVAILABLE";
    private static final String SELECTED_SUFFIX = "_SELECTED";
    private static final String HIDDEN_SUFFIX = "_HIDDEN";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (!(uiComponent instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + uiComponent.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        String hiddenClientId = uiComponent.getClientId(facesContext) + HIDDEN_SUFFIX;
        Map paramValuesMap = facesContext.getExternalContext().getRequestParameterValuesMap();
        if (HtmlRendererUtils.isDisabledOrReadOnly(uiComponent)) {
            return;
        }
        if (paramValuesMap.containsKey(hiddenClientId)) {
            String[] valuesInline = (String[])paramValuesMap.get(hiddenClientId);
            if (valuesInline[0].trim().equals("")) {
                ((EditableValueHolder)uiComponent).setSubmittedValue((Object)new String[0]);
            } else {
                String[] reqValues = valuesInline[0].split(",");
                ((EditableValueHolder)uiComponent).setSubmittedValue((Object)reqValues);
            }
        } else {
            ((EditableValueHolder)uiComponent).setSubmittedValue((Object)new String[0]);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, HtmlSelectManyPicklist.class);
        if (HtmlRendererUtils.isDisplayValueOnly(uiComponent)) {
            HtmlRendererUtils.renderDisplayValueOnlyForSelects(facesContext, uiComponent);
            return;
        }
        HtmlSelectManyPicklist picklist = (HtmlSelectManyPicklist)uiComponent;
        String addButtonText = picklist.getAddButtonText();
        String addAllButtonText = picklist.getAddAllButtonText();
        String removeButtonText = picklist.getRemoveButtonText();
        String removeAllButtonText = picklist.getRemoveAllButtonText();
        String addButtonStyle = picklist.getAddButtonStyle();
        String addAllButtonStyle = picklist.getAddAllButtonStyle();
        String removeButtonStyle = picklist.getRemoveButtonStyle();
        String removeAllButtonStyle = picklist.getRemoveAllButtonStyle();
        String addButtonStyleClass = picklist.getAddButtonStyleClass();
        String addAllButtonStyleClass = picklist.getAddAllButtonStyleClass();
        String removeButtonStyleClass = picklist.getRemoveButtonStyleClass();
        String removeAllButtonStyleClass = picklist.getRemoveAllButtonStyleClass();
        if (addButtonText == null || addButtonText.length() == 0) {
            addButtonText = ">";
        }
        if (addAllButtonText == null || addAllButtonText.length() == 0) {
            addAllButtonText = ">>";
        }
        if (removeButtonText == null || removeButtonText.length() == 0) {
            removeButtonText = "<";
        }
        if (removeAllButtonText == null || removeAllButtonText.length() == 0) {
            removeAllButtonText = "<<";
        }
        this.encodeJavascript(facesContext, uiComponent);
        String availableListClientId = uiComponent.getClientId(facesContext) + AVAILABLE_SUFFIX;
        String selectedListClientId = uiComponent.getClientId(facesContext) + SELECTED_SUFFIX;
        String hiddenFieldCliendId = uiComponent.getClientId(facesContext) + HIDDEN_SUFFIX;
        List selectItemList = RendererUtils.getSelectItemList((UISelectMany)uiComponent);
        Converter converter = HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, uiComponent);
        Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(true, uiComponent, facesContext, converter);
        List selectItemsForSelectedValues = this.selectItemsForSelectedList(facesContext, uiComponent, selectItemList, converter, lookupSet);
        List selectItemsForAvailableList = this.selectItemsForAvailableList(facesContext, uiComponent, selectItemList, selectItemsForSelectedValues, converter);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", uiComponent);
        HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        writer.startElement("tr", uiComponent);
        writer.startElement("td", uiComponent);
        this.encodeSelect(facesContext, (UIComponent)picklist, availableListClientId, this.isDisabled(facesContext, uiComponent), picklist.getSize(), selectItemsForAvailableList, converter);
        writer.endElement("td");
        writer.startElement("td", uiComponent);
        String javascriptAddToSelected = "myfaces_picklist_addToSelected('" + availableListClientId + "','" + selectedListClientId + "','" + hiddenFieldCliendId + "')";
        String javascriptAddAllToSelected = "myfaces_picklist_addAllToSelected('" + availableListClientId + "','" + selectedListClientId + "','" + hiddenFieldCliendId + "')";
        String javascriptRemoveFromSelected = "myfaces_picklist_removeFromSelected('" + availableListClientId + "','" + selectedListClientId + "','" + hiddenFieldCliendId + "')";
        String javascriptRemoveAllFromSelected = "myfaces_picklist_removeAllFromSelected('" + availableListClientId + "','" + selectedListClientId + "','" + hiddenFieldCliendId + "')";
        this.encodeSwapButton(facesContext, uiComponent, javascriptAddToSelected, addButtonText, addButtonStyle, addButtonStyleClass);
        writer.startElement("br", uiComponent);
        writer.endElement("br");
        this.encodeSwapButton(facesContext, uiComponent, javascriptAddAllToSelected, addAllButtonText, addAllButtonStyle, addAllButtonStyleClass);
        writer.startElement("br", uiComponent);
        writer.endElement("br");
        this.encodeSwapButton(facesContext, uiComponent, javascriptRemoveFromSelected, removeButtonText, removeButtonStyle, removeButtonStyleClass);
        writer.startElement("br", uiComponent);
        writer.endElement("br");
        this.encodeSwapButton(facesContext, uiComponent, javascriptRemoveAllFromSelected, removeAllButtonText, removeAllButtonStyle, removeAllButtonStyleClass);
        writer.endElement("td");
        writer.startElement("td", uiComponent);
        this.encodeSelect(facesContext, (UIComponent)picklist, selectedListClientId, this.isDisabled(facesContext, uiComponent), picklist.getSize(), selectItemsForSelectedValues, converter);
        this.encodeHiddenField(facesContext, uiComponent, hiddenFieldCliendId, lookupSet);
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
    }

    private void encodeJavascript(FacesContext facesContext, UIComponent uiComponent) {
        AddResource addResource = AddResourceFactory.getInstance(facesContext);
        addResource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, HtmlPicklistRenderer.class, "picklist.js");
    }

    private void encodeSwapButton(FacesContext facesContext, UIComponent uiComponent, String javaScriptFunction, String text, String style, String styleClass) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("style", (Object)style, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("onclick", (Object)javaScriptFunction, null);
        writer.writeAttribute("value", (Object)text, null);
        writer.endElement("input");
    }

    private void encodeSelect(FacesContext facesContext, UIComponent uiComponent, String clientId, boolean disabled, int size, List selectItemsToDisplay, Converter converter) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("select", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("multiple", (Object)"true", null);
        if (size == 0) {
            writer.writeAttribute("size", (Object)Integer.toString(selectItemsToDisplay.size()), null);
        } else {
            writer.writeAttribute("size", (Object)Integer.toString(size), null);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        HtmlRendererUtils.renderSelectOptions(facesContext, uiComponent, converter, Collections.EMPTY_SET, selectItemsToDisplay);
        writer.writeText((Object)"", null);
        writer.endElement("select");
    }

    private void encodeHiddenField(FacesContext facesContext, UIComponent uiComponent, String hiddenFieldCliendId, Set lookupSet) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", "type");
        writer.writeAttribute("id", (Object)hiddenFieldCliendId, "id");
        writer.writeAttribute("name", (Object)hiddenFieldCliendId, null);
        StringBuffer sb = new StringBuffer();
        int n = 0;
        Iterator i = lookupSet.iterator();
        while (i.hasNext()) {
            if (n > 0) {
                sb.append(",");
            }
            String value = (String)i.next();
            sb.append(value);
            ++n;
        }
        writer.writeAttribute("value", (Object)sb.toString(), null);
        writer.endElement("input");
    }

    private List selectItemsForSelectedList(FacesContext facesContext, UIComponent uiComponent, List selectItemList, Converter converter, Set lookupSet) {
        ArrayList<SelectItem> selectItemForSelectedValues = new ArrayList<SelectItem>(lookupSet.size());
        for (SelectItem selectItem : selectItemList) {
            String itemStrValue = RendererUtils.getConvertedStringValue(facesContext, uiComponent, converter, selectItem);
            for (Object value : lookupSet) {
                if (!value.equals(itemStrValue)) continue;
                selectItemForSelectedValues.add(selectItem);
            }
        }
        return selectItemForSelectedValues;
    }

    private List selectItemsForAvailableList(FacesContext facesContext, UIComponent uiComponent, List selectItemList, List selectItemsForSelectedList, Converter converter) {
        return new ArrayList(CollectionUtils.subtract((Collection)selectItemList, (Collection)selectItemsForSelectedList));
    }
}

