/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeIndent;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNodeBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeIndentRenderer
extends RendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUITreeIndent treeIndent = (AbstractUITreeIndent)component;
        AbstractUITreeNodeBase node = ComponentUtils.findAncestor((UIComponent)treeIndent, AbstractUITreeNodeBase.class);
        AbstractUIData data = ComponentUtils.findAncestor((UIComponent)treeIndent, AbstractUIData.class);
        if (node == null) {
            throw new NullPointerException("No AbstractUITreeNodeBase as ancestor found from '" + component.getClientId() + "'");
        }
        if (data == null) {
            throw new NullPointerException("No AbstractUIData as ancestor found from '" + component.getClientId() + "'");
        }
        boolean folder = node.isFolder();
        int level = node.getLevel();
        boolean showJunctions = treeIndent.isShowJunctions();
        boolean showRootJunction = data.isShowRootJunction();
        boolean expanded = folder && data.getExpandedState().isExpanded(node.getPath());
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.SPAN);
        writer.writeIdAttribute(treeIndent.getClientId(facesContext));
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(treeIndent.getMarkup()), false);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)treeIndent);
        writer.writeClassAttribute(TobagoClass.TREE_NODE__TOGGLE, !folder ? BootstrapClass.INVISIBLE : null, treeIndent.getCustomClass());
        if (!showJunctions || !showRootJunction && level == 0) {
            return;
        }
        writer.startElement(HtmlElements.I);
        if (folder) {
            writer.writeClassAttribute(Icons.FA, expanded ? Icons.MINUS_SQUARE_O : Icons.PLUS_SQUARE_O);
            writer.writeAttribute(DataAttributes.OPEN, Icons.MINUS_SQUARE_O.getName(), false);
            writer.writeAttribute(DataAttributes.CLOSED, Icons.PLUS_SQUARE_O.getName(), false);
        } else {
            writer.writeClassAttribute(Icons.FA, Icons.SQUARE_O, BootstrapClass.INVISIBLE);
        }
        writer.endElement(HtmlElements.I);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.SPAN);
    }
}

