/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation.spring;

import org.apache.myfaces.orchestra.conversation.ConversationBinder;
import org.apache.myfaces.orchestra.conversation.Conversation;

/**
 * Adapter class that forwards calls to the createProxyFor method of the specified
 * AbstractSpringOrchestraScope instance.
 */
class SpringConversationBinder implements ConversationBinder
{
    private AbstractSpringOrchestraScope scope;
    private Conversation c;

    public SpringConversationBinder(AbstractSpringOrchestraScope scope, Conversation c)
    {
        this.scope = scope;
        this.c = c;
    }

    public Object bind(Object instance)
    {
        return scope.createProxyFor(c, instance);
    }
}
