/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.conversation.ConversationManager;
import org.apache.myfaces.orchestra.conversation.basic.LogConversationMessager;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.apache.myfaces.orchestra.frameworkAdapter.local.LocalFrameworkAdapter;

public class ConversationWiperThread
extends Thread {
    private final Log log = LogFactory.getLog(ConversationWiperThread.class);
    private final long checkTime;
    private Set conversationManagers = new HashSet();

    public ConversationWiperThread(long checkTime) {
        this.checkTime = checkTime;
        this.setDaemon(true);
        this.setName(ConversationWiperThread.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConversationManager(ConversationManager cm) {
        Set set = this.conversationManagers;
        synchronized (set) {
            this.conversationManagers.add(cm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConversationManager(ConversationManager cm) {
        Set set = this.conversationManagers;
        synchronized (set) {
            boolean found = this.conversationManagers.remove(cm);
            if (!found) {
                this.log.error((Object)"Conversation Manager not found in remove");
            }
        }
    }

    public void run() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ConversationWiperThread startup");
        }
        this._run();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ConversationWiperThread shtudown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _run() {
        LocalFrameworkAdapter fa = new LocalFrameworkAdapter();
        LogConversationMessager conversationMessager = new LogConversationMessager();
        fa.setConversationMessager(conversationMessager);
        FrameworkAdapter.setCurrentInstance(fa);
        while (!this.isInterrupted()) {
            ConversationManager[] managersArray;
            Set set = this.conversationManagers;
            synchronized (set) {
                managersArray = new ConversationManager[this.conversationManagers.size()];
                this.conversationManagers.toArray(managersArray);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ConversationWiperThread running against " + managersArray.length + " instances."));
            }
            for (int i = 0; i < managersArray.length; ++i) {
                ConversationManager conversationManager = managersArray[i];
                conversationManager.checkTimeouts();
            }
            try {
                Thread.sleep(this.checkTime);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

