/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.resource.bundle;

import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import org.apache.myfaces.extensions.cdi.core.api.projectstage.ProjectStage;
import org.apache.myfaces.extensions.cdi.core.api.resource.bundle.Bundle;
import org.apache.myfaces.extensions.cdi.core.api.resource.bundle.BundleKey;
import org.apache.myfaces.extensions.cdi.core.api.resource.bundle.BundleValue;
import org.apache.myfaces.extensions.cdi.core.api.util.ConfigUtils;
import org.apache.myfaces.extensions.cdi.core.impl.projectstage.ProjectStageProducer;
import org.apache.myfaces.extensions.cdi.core.impl.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
class DefaultResourceBundle
implements org.apache.myfaces.extensions.cdi.core.api.resource.bundle.ResourceBundle {
    private static final long serialVersionUID = 117890966460274247L;
    private String bundleName;
    private Locale locale;

    DefaultResourceBundle() {
    }

    public org.apache.myfaces.extensions.cdi.core.api.resource.bundle.ResourceBundle useBundle(String name) {
        this.bundleName = name;
        return this;
    }

    public org.apache.myfaces.extensions.cdi.core.api.resource.bundle.ResourceBundle useBundle(Class<?> bundleClass) {
        Bundle currentBundle = bundleClass.getAnnotation(Bundle.class);
        if (currentBundle != null) {
            this.bundleName = currentBundle.name();
        }
        if (this.bundleName == null || "".equals(this.bundleName)) {
            String className = bundleClass.getSimpleName();
            className = className.substring(0, 1).toLowerCase() + className.substring(1);
            className = StringUtils.replaceUpperCaseCharactersWithUnderscores(className);
            this.bundleName = bundleClass.getPackage().getName() + "." + className;
        }
        return this;
    }

    public org.apache.myfaces.extensions.cdi.core.api.resource.bundle.ResourceBundle useLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public String getValue(Class<? extends BundleKey> key) {
        if ("".equals(key.getSimpleName()) && BundleKey.class.isAssignableFrom(key.getSuperclass())) {
            key = key.getSuperclass();
        }
        Named named = key.getAnnotation(Named.class);
        String resourceKey = null;
        if (named != null) {
            resourceKey = named.value();
        }
        if (resourceKey == null) {
            resourceKey = StringUtils.replaceUpperCaseCharactersWithUnderscores(key.getSimpleName().substring(0, 1).toLowerCase() + key.getSimpleName().substring(1));
        }
        Class<? extends BundleKey> bundleClass = key.getSuperclass();
        if (this.bundleName == null && !Object.class.getName().equals(bundleClass.getName()) && !BundleValue.class.isAssignableFrom(bundleClass)) {
            this.useBundle(bundleClass);
        } else {
            ArrayList bundleClassCandidates = new ArrayList();
            for (Class<?> interfaceClass : key.getInterfaces()) {
                if (interfaceClass.isAnnotationPresent(Bundle.class)) {
                    this.useBundle(interfaceClass);
                    break;
                }
                if (BundleKey.class.isAssignableFrom(interfaceClass)) continue;
                bundleClassCandidates.add(interfaceClass);
            }
            if (this.bundleName == null && bundleClassCandidates.size() == 1) {
                this.useBundle((Class)bundleClassCandidates.iterator().next());
            } else if (this.bundleName == null && bundleClassCandidates.size() > 1) {
                throw new IllegalStateException(key.getName() + " implements multiple custom interfaces and " + "non of them is annotated with @" + Bundle.class);
            }
        }
        return this.getValue(resourceKey);
    }

    public String getValue(String key) {
        if (key == null) {
            return null;
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.bundleName == null) {
            Logger logger;
            if (ProjectStageProducer.getInstance().getProjectStage() == ProjectStage.Development && (logger = Logger.getLogger(DefaultResourceBundle.class.getName())).isLoggable(Level.WARNING)) {
                logger.warning("no custom bundle name provided - the codi properties file META-INF/myfaces-extcdi.properties is used as fallback");
            }
            this.bundleName = "META-INF/myfaces-extcdi.properties";
        }
        if (this.bundleName.contains("/")) {
            Properties properties = ConfigUtils.getProperties((String)this.bundleName);
            if (properties == null) {
                return null;
            }
            return properties.getProperty(key);
        }
        try {
            return ResourceBundle.getBundle(this.bundleName, this.locale).getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

