/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl;

import java.util.logging.Level;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.inject.Inject;
import org.apache.myfaces.extensions.cdi.core.api.config.CodiConfig;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.ConversationConfig;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.WindowContextConfig;
import org.apache.myfaces.extensions.cdi.core.api.startup.event.StartupEvent;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.impl.AbstractStartupObserver;
import org.apache.myfaces.extensions.cdi.jsf.api.Jsf;
import org.apache.myfaces.extensions.cdi.jsf.api.config.JsfModuleConfig;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;

@ApplicationScoped
public class JsfModuleStartupObserver
extends AbstractStartupObserver {
    @Inject
    private JsfModuleConfig jsfModuleConfig;
    @Inject
    private WindowContextConfig windowContextConfig;
    @Inject
    private ConversationConfig conversationConfig;
    @Inject
    @Jsf
    private MessageContext messageContext;

    protected JsfModuleStartupObserver() {
    }

    protected void logJsfModuleConfiguration(@Observes StartupEvent startupEvent) {
        if (!this.codiCoreConfig.isConfigurationLoggingEnabled()) {
            return;
        }
        try {
            String jsfModuleVersion = this.detectJsfModuleVersion();
            String jsfVersion = this.detectActiveJsfVersion();
            StringBuilder info = new StringBuilder("[Started] MyFaces CODI JSF-Module ");
            info.append(jsfModuleVersion);
            info.append(this.separator);
            if (jsfVersion != null) {
                info.append(jsfVersion);
                info.append(this.separator);
            }
            info.append(this.separator);
            info.append(this.getConfigInfo((CodiConfig)this.jsfModuleConfig));
            info.append(this.getConfigInfo((CodiConfig)this.windowContextConfig));
            info.append(this.getConfigInfo((CodiConfig)this.conversationConfig));
            info.append(this.messageContext.config().toString());
            this.logger.info(info.toString());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "JSF-Module couldn't log the current configuration.Startup will continue!", e);
        }
    }

    protected String detectActiveJsfVersion() {
        PropertyResolver anyJsfClass = FacesContext.getCurrentInstance().getApplication().getPropertyResolver();
        if (anyJsfClass == null) {
            return null;
        }
        String version = ClassUtils.getJarVersion(anyJsfClass.getClass());
        String description = "Used JSF implementation: ";
        if (anyJsfClass.getClass().getName().startsWith("org.apache.myfaces")) {
            return description + "MyFaces Core v" + version;
        }
        if (anyJsfClass.getClass().getName().startsWith("com.sun.faces")) {
            return description + "Mojarra v" + version;
        }
        return null;
    }

    protected String detectJsfModuleVersion() {
        String version = ClassUtils.getJarVersion(JsfModuleStartupObserver.class);
        if (version != null && !version.startsWith("null")) {
            return "v" + version + " for JSF " + this.getTargetJsfVersion();
        }
        return " for JSF " + this.getTargetJsfVersion();
    }

    protected String getTargetJsfVersion() {
        return "1.2";
    }
}

