/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util.token;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;

public class TokenGenerator {
    private final AtomicLong seed = new AtomicLong(this.generateSeed());

    private long generateSeed() {
        SecureRandom rng;
        try {
            rng = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            rng = new SecureRandom();
        }
        byte[] randomBytes = new byte[6];
        rng.nextBytes(randomBytes);
        return new BigInteger(randomBytes).longValue();
    }

    public String getNextToken() {
        long nextToken = this.seed.incrementAndGet();
        return Long.toString(nextToken, 36);
    }

    public AtomicLong getSeed() {
        return this.seed;
    }
}

