/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.resource;

import jakarta.faces.application.ProjectStage;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.shared.resource.ResourceCachedInfo;
import org.apache.myfaces.shared.resource.ResourceLoader;
import org.apache.myfaces.shared.resource.ResourceMeta;
import org.apache.myfaces.shared.util.ConcurrentLRUCache;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

public class ResourceHandlerCache {
    private static final Logger log = Logger.getLogger(ResourceHandlerCache.class.getName());
    private Boolean _resourceCacheEnabled = null;
    private volatile ConcurrentLRUCache<Object, ResourceValue> _resourceCacheMap = null;
    private volatile ConcurrentLRUCache<Object, ResourceValue> _viewResourceCacheMap = null;
    private volatile ConcurrentLRUCache<Object, Boolean> _libraryExistsCacheMap = null;
    private static final String RESOURCE_HANDLER_CACHE_SIZE_ATTRIBUTE = "org.apache.myfaces.RESOURCE_HANDLER_CACHE_SIZE";
    private static final int RESOURCE_HANDLER_CACHE_DEFAULT_SIZE = 500;
    private static final String RESOURCE_HANDLER_CACHE_ENABLED_ATTRIBUTE = "org.apache.myfaces.RESOURCE_HANDLER_CACHE_ENABLED";
    private static final boolean RESOURCE_HANDLER_CACHE_ENABLED_DEFAULT = true;

    public ResourceValue getResource(String resourceName, String libraryName, String contentType, String localePrefix) {
        return this.getResource(resourceName, libraryName, contentType, localePrefix, null);
    }

    public ResourceValue getResource(String resourceName, String libraryName, String contentType, String localePrefix, String contractName) {
        if (!this.isResourceCachingEnabled() || this._resourceCacheMap == null) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to get resource from cache for " + resourceName);
        }
        ResourceKey key = new ResourceKey(resourceName, libraryName, contentType, localePrefix, contractName);
        return this._resourceCacheMap.get(key);
    }

    public boolean containsResource(String resourceName, String libraryName, String contentType, String localePrefix) {
        return this.containsResource(resourceName, libraryName, contentType, localePrefix, null);
    }

    public boolean containsResource(String resourceName, String libraryName, String contentType, String localePrefix, String contractName) {
        if (!this.isResourceCachingEnabled() || this._resourceCacheMap == null) {
            return false;
        }
        ResourceKey key = new ResourceKey(resourceName, libraryName, contentType, localePrefix);
        return this._resourceCacheMap.get(key) != null;
    }

    public void putResource(String resourceName, String libraryName, String contentType, String localePrefix, ResourceMeta resource, ResourceLoader loader) {
        this.putResource(resourceName, libraryName, contentType, localePrefix, null, resource, loader, null);
    }

    public void putResource(String resourceName, String libraryName, String contentType, String localePrefix, String contractName, ResourceMeta resource, ResourceLoader loader, ResourceCachedInfo info) {
        if (!this.isResourceCachingEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to put resource to cache for " + resourceName);
        }
        if (this._resourceCacheMap == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Initializing resource cache map");
            }
            int maxSize = this.getMaxSize();
            this._resourceCacheMap = new ConcurrentLRUCache((maxSize * 4 + 3) / 3, maxSize);
        }
        this._resourceCacheMap.put(new ResourceKey(resourceName, libraryName, contentType, localePrefix, contractName), new ResourceValue(resource, loader, info));
    }

    public ResourceValue getResource(String resourceId) {
        if (!this.isResourceCachingEnabled() || this._resourceCacheMap == null) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to get resource from cache for " + resourceId);
        }
        return this._resourceCacheMap.get(resourceId);
    }

    public ResourceValue getResource(String resourceId, String contractName) {
        if (!this.isResourceCachingEnabled() || this._resourceCacheMap == null) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to get resource from cache for " + resourceId);
        }
        return this._resourceCacheMap.get(contractName + ':' + resourceId);
    }

    public boolean containsResource(String resourceId, String contractName) {
        if (!this.isResourceCachingEnabled() || this._resourceCacheMap == null) {
            return false;
        }
        return this._resourceCacheMap.get(contractName + ':' + resourceId) != null;
    }

    public boolean containsResource(String resourceId) {
        if (!this.isResourceCachingEnabled() || this._resourceCacheMap == null) {
            return false;
        }
        return this._resourceCacheMap.get(resourceId) != null;
    }

    public void putResource(String resourceId, ResourceMeta resource, ResourceLoader loader, ResourceCachedInfo info) {
        if (!this.isResourceCachingEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to put resource to cache for " + resourceId);
        }
        if (this._resourceCacheMap == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Initializing resource cache map");
            }
            int maxSize = this.getMaxSize();
            this._resourceCacheMap = new ConcurrentLRUCache((maxSize * 4 + 3) / 3, maxSize);
        }
        if (resource.getContractName() != null) {
            this._resourceCacheMap.put(resource.getContractName() + ':' + resourceId, new ResourceValue(resource, loader));
        } else {
            this._resourceCacheMap.put(resourceId, new ResourceValue(resource, loader, info));
        }
    }

    public boolean containsViewResource(String resourceName, String contentType, String localePrefix) {
        return this.containsViewResource(resourceName, contentType, localePrefix, null);
    }

    public boolean containsViewResource(String resourceName, String contentType, String localePrefix, String contractName) {
        if (!this.isResourceCachingEnabled() || this._viewResourceCacheMap == null) {
            return false;
        }
        ResourceKey key = new ResourceKey(resourceName, null, contentType, localePrefix, contractName);
        return this._viewResourceCacheMap.get(key) != null;
    }

    public ResourceValue getViewResource(String resourceName, String contentType, String localePrefix) {
        return this.getViewResource(resourceName, contentType, localePrefix, null);
    }

    public ResourceValue getViewResource(String resourceName, String contentType, String localePrefix, String contractName) {
        if (!this.isResourceCachingEnabled() || this._viewResourceCacheMap == null) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to get resource from cache for " + resourceName);
        }
        ResourceKey key = new ResourceKey(resourceName, null, contentType, localePrefix, contractName);
        return this._viewResourceCacheMap.get(key);
    }

    public void putViewResource(String resourceName, String contentType, String localePrefix, ResourceMeta resource, ResourceLoader loader, ResourceCachedInfo info) {
        this.putViewResource(resourceName, contentType, localePrefix, null, resource, loader, info);
    }

    public void putViewResource(String resourceName, String contentType, String localePrefix, String contractName, ResourceMeta resource, ResourceLoader loader, ResourceCachedInfo info) {
        if (!this.isResourceCachingEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to put resource to cache for " + resourceName);
        }
        if (this._viewResourceCacheMap == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Initializing resource cache map");
            }
            int maxSize = this.getMaxSize();
            this._viewResourceCacheMap = new ConcurrentLRUCache((maxSize * 4 + 3) / 3, maxSize);
        }
        this._viewResourceCacheMap.put(new ResourceKey(resourceName, null, contentType, localePrefix, contractName), new ResourceValue(resource, loader, info));
    }

    public Boolean libraryExists(String libraryName) {
        if (!this.isResourceCachingEnabled() || this._libraryExistsCacheMap == null) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to get libraryExists from cache for " + libraryName);
        }
        return this._libraryExistsCacheMap.get(libraryName);
    }

    public void confirmLibraryExists(String libraryName) {
        if (!this.isResourceCachingEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to set confirmLibraryExists on cache " + libraryName);
        }
        if (this._libraryExistsCacheMap == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Initializing resource cache map");
            }
            int maxSize = this.getMaxSize() / 10;
            this._libraryExistsCacheMap = new ConcurrentLRUCache((maxSize * 4 + 3) / 3, maxSize);
        }
        this._libraryExistsCacheMap.put(libraryName, Boolean.TRUE);
    }

    public void confirmLibraryNotExists(String libraryName) {
        if (!this.isResourceCachingEnabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Attemping to set confirmLibraryExists on cache " + libraryName);
        }
        if (this._libraryExistsCacheMap == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Initializing resource cache map");
            }
            int maxSize = this.getMaxSize() / 5;
            this._libraryExistsCacheMap = new ConcurrentLRUCache((maxSize * 4 + 3) / 3, maxSize);
        }
        this._libraryExistsCacheMap.put(libraryName, Boolean.FALSE);
    }

    private boolean isResourceCachingEnabled() {
        if (this._resourceCacheEnabled == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (!facesContext.isProjectStage(ProjectStage.Production)) {
                this._resourceCacheEnabled = Boolean.FALSE;
                return this._resourceCacheEnabled;
            }
            ExternalContext externalContext = facesContext.getExternalContext();
            if (externalContext == null) {
                return false;
            }
            this._resourceCacheEnabled = WebConfigParamUtils.getBooleanInitParameter(externalContext, RESOURCE_HANDLER_CACHE_ENABLED_ATTRIBUTE, true);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "MyFaces Resource Caching Enabled=" + this._resourceCacheEnabled);
            }
        }
        return this._resourceCacheEnabled;
    }

    private int getMaxSize() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        return WebConfigParamUtils.getIntegerInitParameter(externalContext, RESOURCE_HANDLER_CACHE_SIZE_ATTRIBUTE, 500);
    }

    public static class ResourceValue {
        private final ResourceMeta resourceMeta;
        private final ResourceLoader resourceLoader;
        private final ResourceCachedInfo info;

        public ResourceValue(ResourceMeta resourceMeta, ResourceLoader resourceLoader) {
            this.resourceMeta = resourceMeta;
            this.resourceLoader = resourceLoader;
            this.info = null;
        }

        public ResourceValue(ResourceMeta resourceMeta, ResourceLoader resourceLoader, ResourceCachedInfo info) {
            this.resourceMeta = resourceMeta;
            this.resourceLoader = resourceLoader;
            this.info = info;
        }

        public ResourceMeta getResourceMeta() {
            return this.resourceMeta;
        }

        public ResourceLoader getResourceLoader() {
            return this.resourceLoader;
        }

        public ResourceCachedInfo getCachedInfo() {
            return this.info;
        }
    }

    public static class ResourceKey {
        private final String resourceName;
        private final String libraryName;
        private final String contentType;
        private final String localePrefix;
        private final String contractName;

        public ResourceKey(String resourceName, String libraryName, String contentType, String localePrefix) {
            this(resourceName, libraryName, contentType, localePrefix, null);
        }

        public ResourceKey(String resourceName, String libraryName, String contentType, String localePrefix, String contractName) {
            this.resourceName = resourceName;
            this.libraryName = libraryName;
            this.contentType = contentType;
            this.localePrefix = localePrefix;
            this.contractName = contractName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceKey that = (ResourceKey)o;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) {
                return false;
            }
            if (this.libraryName != null ? !this.libraryName.equals(that.libraryName) : that.libraryName != null) {
                return false;
            }
            if (this.localePrefix != null ? !this.localePrefix.equals(that.localePrefix) : that.localePrefix != null) {
                return false;
            }
            if (this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null) {
                return false;
            }
            return !(this.contractName != null ? !this.contractName.equals(that.contractName) : that.contractName != null);
        }

        public int hashCode() {
            int result = this.resourceName != null ? this.resourceName.hashCode() : 0;
            result = 31 * result + (this.libraryName != null ? this.libraryName.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.localePrefix != null ? this.localePrefix.hashCode() : 0);
            result = 31 * result + (this.contractName != null ? this.contractName.hashCode() : 0);
            return result;
        }
    }
}

