/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html.util;

import java.io.IOException;
import javax.faces.FacesWrapper;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.resource.ContractResource;

public class ResourceUtils {
    @Deprecated
    public static final String JAVAX_FACES_LIBRARY_NAME = "javax.faces";
    @Deprecated
    public static final String JSF_JS_RESOURCE_NAME = "jsf.js";
    public static final String MYFACES_JS_RESOURCE_NAME = "oamSubmit.js";
    public static final String MYFACES_JS_RESOURCE_NAME_UNCOMPRESSED = "oamSubmit-uncompressed.js";
    public static final String MYFACES_LIBRARY_NAME = "org.apache.myfaces";
    private static final String RENDERED_MYFACES_JS = "org.apache.myfaces.RENDERED_MYFACES_JS";
    public static final String JSF_MYFACES_JSFJS_MINIMAL = "minimal";
    public static final String JSF_MYFACES_JSFJS_MINIMAL_MODERN = "minimal-modern";
    public static final String JSF_MYFACES_JSFJS_NORMAL = "normal";
    public static final String JSF_UNCOMPRESSED_JS_RESOURCE_NAME = "jsf-uncompressed.js";
    public static final String JSF_MINIMAL_JS_RESOURCE_NAME = "jsf-minimal.js";
    public static final String JSF_MINIMAL_MODERN_JS_RESOURCE_NAME = "jsf-minimal-modern.js";
    public static final String JSF_MYFACES_JSFJS_I18N = "jsf-i18n.js";
    public static final String JSF_MYFACES_JSFJS_EXPERIMENTAL = "jsf-experimental.js";
    public static final String JSF_MYFACES_JSFJS_LEGACY = "jsf-legacy.js";
    private static final String RENDERED_JSF_JS = "org.apache.myfaces.RENDERED_JSF_JS";
    public static final String HEAD_TARGET = "head";
    public static final String BODY_TARGET = "body";
    public static final String FORM_TARGET = "form";
    public static final String JAVAX_FACES_OUTPUT_COMPONENT_TYPE = "javax.faces.Output";
    public static final String JAVAX_FACES_TEXT_RENDERER_TYPE = "javax.faces.Text";
    public static final String DEFAULT_SCRIPT_RENDERER_TYPE = "javax.faces.resource.Script";
    public static final String DEFAULT_STYLESHEET_RENDERER_TYPE = "javax.faces.resource.Stylesheet";

    public static void markScriptAsRendered(FacesContext facesContext, String libraryName, String resourceName) {
        facesContext.getApplication().getResourceHandler().markResourceRendered(facesContext, resourceName, libraryName);
    }

    public static void markStylesheetAsRendered(FacesContext facesContext, String libraryName, String resourceName) {
        facesContext.getApplication().getResourceHandler().markResourceRendered(facesContext, resourceName, libraryName);
    }

    public static boolean isRenderedScript(FacesContext facesContext, String libraryName, String resourceName) {
        return facesContext.getApplication().getResourceHandler().isResourceRendered(facesContext, resourceName, libraryName);
    }

    public static boolean isRenderedStylesheet(FacesContext facesContext, String libraryName, String resourceName) {
        return facesContext.getApplication().getResourceHandler().isResourceRendered(facesContext, resourceName, libraryName);
    }

    public static void writeScriptInline(FacesContext facesContext, ResponseWriter writer, String libraryName, String resourceName) throws IOException {
        if (!ResourceUtils.isRenderedScript(facesContext, libraryName, resourceName)) {
            if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isRiImplAvailable()) {
                UIComponent outputScript = facesContext.getApplication().createComponent(facesContext, JAVAX_FACES_OUTPUT_COMPONENT_TYPE, DEFAULT_SCRIPT_RENDERER_TYPE);
                outputScript.getAttributes().put("name", resourceName);
                outputScript.getAttributes().put("library", libraryName);
                outputScript.encodeAll(facesContext);
            } else {
                Resource resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, libraryName);
                ResourceUtils.markScriptAsRendered(facesContext, libraryName, resourceName);
                writer.startElement("script", null);
                writer.writeAttribute("type", (Object)"text/javascript", null);
                writer.writeURIAttribute("src", (Object)resource.getRequestPath(), null);
                writer.endElement("script");
            }
        }
    }

    public static void renderDefaultJsfJsInlineIfNecessary(FacesContext facesContext, ResponseWriter writer) throws IOException {
        if (facesContext.getAttributes().containsKey(RENDERED_JSF_JS)) {
            return;
        }
        if (ResourceUtils.isRenderedScript(facesContext, JAVAX_FACES_LIBRARY_NAME, JSF_JS_RESOURCE_NAME)) {
            facesContext.getAttributes().put(RENDERED_JSF_JS, Boolean.TRUE);
            return;
        }
        if (facesContext.getPartialViewContext() != null && (facesContext.getPartialViewContext().isPartialRequest() || facesContext.getPartialViewContext().isAjaxRequest())) {
            return;
        }
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isRiImplAvailable()) {
            UIComponent outputScript = facesContext.getApplication().createComponent(facesContext, JAVAX_FACES_OUTPUT_COMPONENT_TYPE, DEFAULT_SCRIPT_RENDERER_TYPE);
            outputScript.getAttributes().put("name", JSF_JS_RESOURCE_NAME);
            outputScript.getAttributes().put("library", JAVAX_FACES_LIBRARY_NAME);
            outputScript.encodeAll(facesContext);
        } else {
            Resource resource = facesContext.getApplication().getResourceHandler().createResource(JSF_JS_RESOURCE_NAME, JAVAX_FACES_LIBRARY_NAME);
            ResourceUtils.markScriptAsRendered(facesContext, JAVAX_FACES_LIBRARY_NAME, JSF_JS_RESOURCE_NAME);
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeURIAttribute("src", (Object)resource.getRequestPath(), null);
            writer.endElement("script");
        }
        facesContext.getAttributes().put(RENDERED_JSF_JS, Boolean.TRUE);
    }

    public static void renderMyfacesJSInlineIfNecessary(FacesContext facesContext, ResponseWriter writer) throws IOException {
        if (facesContext.getAttributes().containsKey(RENDERED_MYFACES_JS)) {
            return;
        }
        if (facesContext.getPartialViewContext() != null && (facesContext.getPartialViewContext().isPartialRequest() || facesContext.getPartialViewContext().isAjaxRequest())) {
            return;
        }
        if (ResourceUtils.isRenderedScript(facesContext, MYFACES_LIBRARY_NAME, MYFACES_JS_RESOURCE_NAME)) {
            facesContext.getAttributes().put(RENDERED_MYFACES_JS, Boolean.TRUE);
            return;
        }
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isRiImplAvailable()) {
            UIComponent outputScript = facesContext.getApplication().createComponent(facesContext, JAVAX_FACES_OUTPUT_COMPONENT_TYPE, DEFAULT_SCRIPT_RENDERER_TYPE);
            outputScript.getAttributes().put("name", MYFACES_JS_RESOURCE_NAME);
            outputScript.getAttributes().put("library", MYFACES_LIBRARY_NAME);
            outputScript.encodeAll(facesContext);
        } else {
            Resource resource = facesContext.getApplication().getResourceHandler().createResource(MYFACES_JS_RESOURCE_NAME, MYFACES_LIBRARY_NAME);
            ResourceUtils.markScriptAsRendered(facesContext, MYFACES_LIBRARY_NAME, MYFACES_JS_RESOURCE_NAME);
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeURIAttribute("src", (Object)resource.getRequestPath(), null);
            writer.endElement("script");
        }
        facesContext.getAttributes().put(RENDERED_MYFACES_JS, Boolean.TRUE);
    }

    public static String getContractName(Resource resource) {
        while (resource != null) {
            if (resource instanceof ContractResource) {
                return ((ContractResource)resource).getContractName();
            }
            if (resource instanceof FacesWrapper) {
                resource = (Resource)((FacesWrapper)resource).getWrapped();
                continue;
            }
            resource = null;
        }
        return null;
    }
}

