/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.webapp.FacesServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.myfaces.webapp.DelegatedFacesServlet;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.FacesInitializerFactory;

public class MyFacesServlet
implements Servlet,
DelegatedFacesServlet {
    private static final Logger log = Logger.getLogger(MyFacesServlet.class.getName());
    private final FacesServlet delegate = new FacesServlet();
    private FacesInitializer _facesInitializer;

    public void setFacesInitializer(FacesInitializer facesInitializer) {
        this._facesInitializer = facesInitializer;
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public ServletConfig getServletConfig() {
        return this.delegate.getServletConfig();
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        if (this._facesInitializer == null) {
            this._facesInitializer = FacesInitializerFactory.getFacesInitializer(servletContext);
        }
        FacesContext facesContext = this._facesInitializer.initStartupFacesContext(servletContext);
        Boolean b = (Boolean)servletContext.getAttribute("org.apache.myfaces.webapp.StartupServletContextListener.FACES_INIT_DONE");
        if (b == null || !b.booleanValue()) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("ServletContextListener not yet called");
            }
            this._facesInitializer.initFaces(servletConfig.getServletContext());
        }
        this._facesInitializer.destroyStartupFacesContext(facesContext);
        this.delegate.init(servletConfig);
        log.info("MyFacesServlet for context '" + servletConfig.getServletContext().getRealPath("/") + "' initialized.");
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("MyFacesServlet service start");
        }
        this.delegate.service(request, response);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("MyFacesServlet service finished");
        }
    }
}

