/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.pool.impl;

import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.context.RequestViewContext;
import org.apache.myfaces.util.WebConfigParamUtils;
import org.apache.myfaces.view.facelets.pool.RestoreViewFromPoolResult;
import org.apache.myfaces.view.facelets.pool.ViewEntry;
import org.apache.myfaces.view.facelets.pool.ViewPool;
import org.apache.myfaces.view.facelets.pool.ViewStructureMetadata;
import org.apache.myfaces.view.facelets.pool.impl.DynamicViewKey;
import org.apache.myfaces.view.facelets.pool.impl.MetadataViewKey;
import org.apache.myfaces.view.facelets.pool.impl.MetadataViewKeyImpl;
import org.apache.myfaces.view.facelets.pool.impl.SoftViewEntry;
import org.apache.myfaces.view.facelets.pool.impl.ViewPoolEntryHolder;
import org.apache.myfaces.view.facelets.pool.impl.ViewStructureMetadataImpl;
import org.apache.myfaces.view.facelets.pool.impl.WeakViewEntry;
import org.apache.myfaces.view.facelets.tag.jsf.FaceletState;

public class ViewPoolImpl
extends ViewPool {
    private static final String SKIP_VIEW_MAP_SAVE_STATE = "oam.viewPool.SKIP_VIEW_MAP_SAVE_STATE";
    private Map<MetadataViewKey, ViewPoolEntryHolder> staticStructureViewPool = new ConcurrentHashMap<MetadataViewKey, ViewPoolEntryHolder>();
    private Map<MetadataViewKey, Map<DynamicViewKey, ViewPoolEntryHolder>> dynamicStructureViewPool;
    private Map<MetadataViewKey, ViewPoolEntryHolder> partialStructureViewPool = new ConcurrentHashMap<MetadataViewKey, ViewPoolEntryHolder>();
    private final int maxCount;
    private final int dynamicPartialLimit;
    private final boolean entryWeak;
    private final boolean deferredNavigation;
    private Map<MetadataViewKey, ViewStructureMetadata> staticStructureViewMetadataMap;
    private Map<MetadataViewKey, Map<DynamicViewKey, ViewStructureMetadata>> dynamicStructureViewMetadataMap;

    public ViewPoolImpl(FacesContext facesContext, Map<String, String> parameters) {
        this.dynamicStructureViewPool = new ConcurrentHashMap<MetadataViewKey, Map<DynamicViewKey, ViewPoolEntryHolder>>();
        this.maxCount = WebConfigParamUtils.getIntegerInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.VIEW_POOL_MAX_POOL_SIZE", parameters.containsKey("org.apache.myfaces.VIEW_POOL_MAX_POOL_SIZE") ? Integer.parseInt(parameters.get("org.apache.myfaces.VIEW_POOL_MAX_POOL_SIZE")) : 5);
        this.dynamicPartialLimit = WebConfigParamUtils.getIntegerInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.VIEW_POOL_MAX_DYNAMIC_PARTIAL_LIMIT", parameters.containsKey("org.apache.myfaces.VIEW_POOL_MAX_DYNAMIC_PARTIAL_LIMIT") ? Integer.parseInt(parameters.get("org.apache.myfaces.VIEW_POOL_MAX_DYNAMIC_PARTIAL_LIMIT")) : 2);
        String entryMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.VIEW_POOL_ENTRY_MODE", parameters.containsKey("org.apache.myfaces.VIEW_POOL_ENTRY_MODE") ? parameters.get("org.apache.myfaces.VIEW_POOL_ENTRY_MODE") : "soft");
        this.entryWeak = "weak".equals(entryMode);
        String deferredNavigationVal = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.VIEW_POOL_DEFERRED_NAVIGATION", parameters.containsKey("org.apache.myfaces.VIEW_POOL_DEFERRED_NAVIGATION") ? parameters.get("org.apache.myfaces.VIEW_POOL_DEFERRED_NAVIGATION") : "false");
        this.deferredNavigation = Boolean.valueOf(deferredNavigationVal);
        this.staticStructureViewMetadataMap = new ConcurrentHashMap<MetadataViewKey, ViewStructureMetadata>();
        this.dynamicStructureViewMetadataMap = new ConcurrentHashMap<MetadataViewKey, Map<DynamicViewKey, ViewStructureMetadata>>();
    }

    protected void pushStaticStructureView(FacesContext context, MetadataViewKey key, ViewEntry entry) {
        ViewPoolEntryHolder q = this.staticStructureViewPool.computeIfAbsent(key, k -> new ViewPoolEntryHolder(this.maxCount));
        q.add(entry);
    }

    protected ViewEntry popStaticStructureView(FacesContext context, MetadataViewKey key) {
        ViewPoolEntryHolder q = this.staticStructureViewPool.get(key);
        if (q == null) {
            return null;
        }
        ViewEntry entry = q.poll();
        if (entry == null) {
            return null;
        }
        do {
            if (!entry.activate()) continue;
            return entry;
        } while ((entry = q.poll()) != null);
        return null;
    }

    protected void pushPartialStructureView(FacesContext context, MetadataViewKey key, ViewEntry entry) {
        ViewPoolEntryHolder q = this.partialStructureViewPool.get(key);
        if (q == null) {
            q = new ViewPoolEntryHolder(this.maxCount);
            this.partialStructureViewPool.put(key, q);
        }
        q.add(entry);
    }

    protected ViewEntry popPartialStructureView(FacesContext context, MetadataViewKey key) {
        ViewPoolEntryHolder q = this.partialStructureViewPool.get(key);
        if (q == null) {
            return null;
        }
        ViewEntry entry = q.poll();
        if (entry == null) {
            return null;
        }
        do {
            if (!entry.activate()) continue;
            return entry;
        } while ((entry = q.poll()) != null);
        return null;
    }

    protected MetadataViewKey deriveViewKey(FacesContext facesContext, UIViewRoot root) {
        MetadataViewKeyImpl viewKey;
        if (!facesContext.getResourceLibraryContracts().isEmpty()) {
            String[] contracts = new String[facesContext.getResourceLibraryContracts().size()];
            contracts = facesContext.getResourceLibraryContracts().toArray(contracts);
            viewKey = new MetadataViewKeyImpl(root.getViewId(), root.getRenderKitId(), root.getLocale(), contracts);
        } else {
            viewKey = new MetadataViewKeyImpl(root.getViewId(), root.getRenderKitId(), root.getLocale());
        }
        return viewKey;
    }

    protected ViewEntry generateViewEntry(FacesContext facesContext, UIViewRoot root) {
        return this.entryWeak ? new WeakViewEntry(root) : new SoftViewEntry(root);
    }

    protected DynamicViewKey generateDynamicStructureViewKey(FacesContext facesContext, UIViewRoot root, FaceletState faceletDynamicState) {
        return new DynamicViewKey(faceletDynamicState);
    }

    protected void pushDynamicStructureView(FacesContext context, UIViewRoot root, DynamicViewKey key, ViewEntry entry) {
        MetadataViewKey ordinaryKey = this.deriveViewKey(context, root);
        Map map = this.dynamicStructureViewPool.computeIfAbsent(ordinaryKey, k -> new ConcurrentHashMap());
        ViewPoolEntryHolder q = map.computeIfAbsent(key, k -> new ViewPoolEntryHolder(this.maxCount));
        if (!q.add(entry)) {
            this.pushPartialStructureView(context, ordinaryKey, entry);
        }
    }

    protected ViewEntry popDynamicStructureView(FacesContext context, UIViewRoot root, DynamicViewKey key) {
        MetadataViewKey ordinaryKey = this.deriveViewKey(context, root);
        Map<DynamicViewKey, ViewPoolEntryHolder> map = this.dynamicStructureViewPool.get(ordinaryKey);
        if (map == null) {
            return null;
        }
        ViewPoolEntryHolder q = map.get(key);
        if (q == null) {
            return null;
        }
        ViewEntry entry = q.poll();
        while (entry != null) {
            if (entry.activate()) {
                return entry;
            }
            entry = q.poll();
        }
        return null;
    }

    @Override
    public void pushStaticStructureView(FacesContext context, UIViewRoot root) {
        MetadataViewKey key = this.deriveViewKey(context, root);
        if (this.staticStructureViewMetadataMap.containsKey(key)) {
            ViewEntry value = this.generateViewEntry(context, root);
            this.pushStaticStructureView(context, key, value);
        }
    }

    @Override
    public ViewEntry popStaticOrPartialStructureView(FacesContext context, UIViewRoot root) {
        MetadataViewKey key = this.deriveViewKey(context, root);
        ViewEntry entry = this.popStaticStructureView(context, key);
        if (entry != null) {
            entry.setResult(RestoreViewFromPoolResult.COMPLETE);
        } else {
            entry = this.popPartialStructureView(context, key);
            if (entry != null) {
                entry.setResult(RestoreViewFromPoolResult.REFRESH_REQUIRED);
            } else {
                Map<DynamicViewKey, ViewPoolEntryHolder> map = this.dynamicStructureViewPool.get(key);
                if (map != null) {
                    try {
                        ViewPoolEntryHolder maxEntry = null;
                        long max = -1L;
                        for (ViewPoolEntryHolder e : map.values()) {
                            long count = e.getCount();
                            if (count <= max || count <= (long)this.dynamicPartialLimit) continue;
                            maxEntry = e;
                            max = count;
                        }
                        if (maxEntry != null && (entry = maxEntry.poll()) != null) {
                            while (!entry.activate() && (entry = maxEntry.poll()) != null) {
                            }
                            if (entry != null) {
                                entry.setResult(RestoreViewFromPoolResult.REFRESH_REQUIRED);
                            }
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        // empty catch block
                    }
                }
            }
        }
        return entry;
    }

    @Override
    public void pushDynamicStructureView(FacesContext context, UIViewRoot root, FaceletState faceletDynamicState) {
        DynamicViewKey key = this.generateDynamicStructureViewKey(context, root, faceletDynamicState);
        MetadataViewKey ordinaryKey = this.deriveViewKey(context, root);
        Map<DynamicViewKey, ViewStructureMetadata> map = this.dynamicStructureViewMetadataMap.get(ordinaryKey);
        if (map != null) {
            ViewEntry value = this.generateViewEntry(context, root);
            this.pushDynamicStructureView(context, root, key, value);
        }
    }

    @Override
    public ViewEntry popDynamicStructureView(FacesContext context, UIViewRoot root, FaceletState faceletDynamicState) {
        DynamicViewKey key = this.generateDynamicStructureViewKey(context, root, faceletDynamicState);
        ViewEntry entry = this.popDynamicStructureView(context, root, key);
        if (entry != null) {
            entry.setResult(RestoreViewFromPoolResult.COMPLETE);
        }
        return entry;
    }

    @Override
    public void pushPartialStructureView(FacesContext context, UIViewRoot root) {
        MetadataViewKey key = this.deriveViewKey(context, root);
        ViewEntry value = this.generateViewEntry(context, root);
        this.pushPartialStructureView(context, key, value);
    }

    @Override
    public boolean isWorthToRecycleThisView(FacesContext context, UIViewRoot root) {
        MetadataViewKey key = this.deriveViewKey(context, root);
        ViewPoolEntryHolder q = this.partialStructureViewPool.get(key);
        return q == null || !q.isFull();
    }

    @Override
    public void storeStaticViewStructureMetadata(FacesContext context, UIViewRoot root, FaceletState faceletState) {
        MetadataViewKey key = this.deriveViewKey(context, root);
        if (!this.staticStructureViewMetadataMap.containsKey(key)) {
            RequestViewContext rvc = RequestViewContext.getCurrentInstance(context);
            Object state = this.saveViewRootState(context, root);
            ViewStructureMetadataImpl metadata = new ViewStructureMetadataImpl(state, rvc.getRequestViewMetadata().cloneInstance());
            this.staticStructureViewMetadataMap.put(key, metadata);
        }
    }

    @Override
    public ViewStructureMetadata retrieveStaticViewStructureMetadata(FacesContext context, UIViewRoot root) {
        MetadataViewKey key = this.deriveViewKey(context, root);
        return this.staticStructureViewMetadataMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object saveViewRootState(FacesContext context, UIViewRoot root) {
        Object state;
        if (root.getViewMap(false) != null) {
            try {
                context.getAttributes().put(SKIP_VIEW_MAP_SAVE_STATE, Boolean.TRUE);
                state = root.saveState(context);
            }
            finally {
                context.getAttributes().remove(SKIP_VIEW_MAP_SAVE_STATE);
            }
        } else {
            state = root.saveState(context);
        }
        return state;
    }

    @Override
    public void storeDynamicViewStructureMetadata(FacesContext context, UIViewRoot root, FaceletState faceletDynamicState) {
        DynamicViewKey key = this.generateDynamicStructureViewKey(context, root, faceletDynamicState);
        MetadataViewKey ordinaryKey = this.deriveViewKey(context, root);
        if (!this.dynamicStructureViewMetadataMap.containsKey(ordinaryKey)) {
            Map map = this.dynamicStructureViewMetadataMap.computeIfAbsent(ordinaryKey, k -> new ConcurrentHashMap());
            RequestViewContext rvc = RequestViewContext.getCurrentInstance(context);
            Object state = this.saveViewRootState(context, root);
            ViewStructureMetadataImpl metadata = new ViewStructureMetadataImpl(state, rvc.getRequestViewMetadata().cloneInstance());
            map.put(key, metadata);
        }
    }

    @Override
    public ViewStructureMetadata retrieveDynamicViewStructureMetadata(FacesContext context, UIViewRoot root, FaceletState faceletDynamicState) {
        DynamicViewKey key = this.generateDynamicStructureViewKey(context, root, faceletDynamicState);
        MetadataViewKey ordinaryKey = this.deriveViewKey(context, root);
        Map<DynamicViewKey, ViewStructureMetadata> map = this.dynamicStructureViewMetadataMap.get(ordinaryKey);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    @Override
    public boolean isDeferredNavigationEnabled() {
        return this.deferredNavigation;
    }
}

