/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.spi.AnnotationProvider;
import org.apache.myfaces.spi.impl.DefaultAnnotationProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class AnnotationProviderFactory {
    private static final String FACTORY_KEY = AnnotationProviderFactory.class.getName();

    public static AnnotationProviderFactory getAnnotationProviderFactory(ExternalContext ctx) {
        AnnotationProviderFactory instance = (AnnotationProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        AnnotationProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                ExternalContext ectx = ctx;
                lpf = (AnnotationProviderFactory)AccessController.doPrivileged(() -> SpiUtils.build(ectx, AnnotationProviderFactory.class, DefaultAnnotationProviderFactory.class));
            } else {
                lpf = (AnnotationProviderFactory)SpiUtils.build(ctx, AnnotationProviderFactory.class, DefaultAnnotationProviderFactory.class);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (lpf != null) {
            AnnotationProviderFactory.setAnnotationProviderFactory(ctx, lpf);
        }
        return lpf;
    }

    public static void setAnnotationProviderFactory(ExternalContext ctx, AnnotationProviderFactory instance) {
        ctx.getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract AnnotationProvider createAnnotationProvider(ExternalContext var1);

    public AnnotationProvider getAnnotationProvider(ExternalContext externalContext) {
        return this.createAnnotationProvider(externalContext);
    }
}

