/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.component.ActionSource;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public class ActionListenerImpl
implements ActionListener {
    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        ActionSource actionSource = (ActionSource)actionEvent.getComponent();
        MethodBinding methodBinding = actionSource.getAction();
        String fromAction = null;
        String outcome = null;
        if (methodBinding != null) {
            fromAction = methodBinding.getExpressionString();
            try {
                Object objOutcome = methodBinding.invoke(facesContext, null);
                if (objOutcome != null) {
                    outcome = objOutcome.toString();
                }
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw new FacesException("Error calling action method of component with id " + actionEvent.getComponent().getClientId(facesContext), (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new FacesException("Error calling action method of component with id " + actionEvent.getComponent().getClientId(facesContext), (Throwable)e);
            }
        }
        NavigationHandler navigationHandler = application.getNavigationHandler();
        navigationHandler.handleNavigation(facesContext, fromAction, outcome);
        facesContext.renderResponse();
    }
}

