/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.converter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.commons.converter._AttachedListStateWrapper;
import org.apache.myfaces.commons.converter._AttachedStateWrapper;
import org.apache.myfaces.commons.util.MessageUtils;

public abstract class ConverterBase
implements StateHolder,
Converter {
    private String _summaryMessage = null;
    private String _detailMessage = null;
    private boolean _transient = false;
    private transient FacesContext _facesContext;
    private Map _valueBindingMap = null;

    public String getSummaryMessage() {
        if (this._summaryMessage != null) {
            return this._summaryMessage;
        }
        ValueBinding vb = this.getValueBinding("summaryMessage");
        return vb != null ? this.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setSummaryMessage(String message) {
        this._summaryMessage = message;
    }

    public String getDetailMessage() {
        if (this._detailMessage != null) {
            return this._detailMessage;
        }
        ValueBinding vb = this.getValueBinding("detailMessage");
        return vb != null ? this.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setDetailMessage(String message) {
        this._detailMessage = message;
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this._summaryMessage, this._detailMessage, this.saveValueBindingMap(context)};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this._summaryMessage = (String)values[0];
        this._detailMessage = (String)values[1];
        this.restoreValueBindingMap(context, values[2]);
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    protected FacesMessage getFacesMessage(String defaultMessage, Object[] args) {
        FacesMessage msg;
        if (this.getSummaryMessage() == null && this.getDetailMessage() == null) {
            msg = MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)defaultMessage, (Object[])args);
        } else {
            Locale locale = MessageUtils.getCurrentLocale();
            String summaryText = MessageUtils.substituteParams((Locale)locale, (String)this.getSummaryMessage(), (Object[])args);
            String detailText = MessageUtils.substituteParams((Locale)locale, (String)this.getDetailMessage(), (Object[])args);
            msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, summaryText, detailText);
        }
        return msg;
    }

    public ValueBinding getValueBinding(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this._valueBindingMap == null) {
            return null;
        }
        return (ValueBinding)this._valueBindingMap.get(name);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this._valueBindingMap == null) {
            this._valueBindingMap = new HashMap();
        }
        this._valueBindingMap.put(name, binding);
    }

    private Object saveValueBindingMap(FacesContext context) {
        if (this._valueBindingMap != null) {
            int initCapacity = (this._valueBindingMap.size() * 4 + 3) / 3;
            HashMap stateMap = new HashMap(initCapacity);
            for (Map.Entry entry : this._valueBindingMap.entrySet()) {
                stateMap.put(entry.getKey(), ConverterBase.saveAttachedState(context, entry.getValue()));
            }
            return stateMap;
        }
        return null;
    }

    private void restoreValueBindingMap(FacesContext context, Object stateObj) {
        if (stateObj != null) {
            Map stateMap = (Map)stateObj;
            int initCapacity = (stateMap.size() * 4 + 3) / 3;
            this._valueBindingMap = new HashMap(initCapacity);
            for (Map.Entry entry : stateMap.entrySet()) {
                this._valueBindingMap.put(entry.getKey(), ConverterBase.restoreAttachedState(context, entry.getValue()));
            }
        } else {
            this._valueBindingMap = null;
        }
    }

    public static Object saveAttachedState(FacesContext context, Object attachedObject) {
        if (attachedObject == null) {
            return null;
        }
        if (attachedObject instanceof List) {
            ArrayList<Object> lst = new ArrayList<Object>(((List)attachedObject).size());
            Iterator it = ((List)attachedObject).iterator();
            while (it.hasNext()) {
                lst.add(ConverterBase.saveAttachedState(context, it.next()));
            }
            return new _AttachedListStateWrapper(lst);
        }
        if (attachedObject instanceof StateHolder) {
            if (((StateHolder)attachedObject).isTransient()) {
                return null;
            }
            return new _AttachedStateWrapper(attachedObject.getClass(), ((StateHolder)attachedObject).saveState(context));
        }
        if (attachedObject instanceof Serializable) {
            return attachedObject;
        }
        return new _AttachedStateWrapper(attachedObject.getClass(), null);
    }

    public static Object restoreAttachedState(FacesContext context, Object stateObj) throws IllegalStateException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (stateObj == null) {
            return null;
        }
        if (stateObj instanceof _AttachedListStateWrapper) {
            List lst = ((_AttachedListStateWrapper)stateObj).getWrappedStateList();
            ArrayList<Object> restoredList = new ArrayList<Object>(lst.size());
            Iterator it = lst.iterator();
            while (it.hasNext()) {
                restoredList.add(ConverterBase.restoreAttachedState(context, it.next()));
            }
            return restoredList;
        }
        if (stateObj instanceof _AttachedStateWrapper) {
            Object restoredObject;
            Class clazz = ((_AttachedStateWrapper)stateObj).getClazz();
            try {
                restoredObject = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not restore StateHolder of type " + clazz.getName() + " (missing no-args constructor?)", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (restoredObject instanceof StateHolder) {
                Object wrappedState = ((_AttachedStateWrapper)stateObj).getWrappedStateObject();
                ((StateHolder)restoredObject).restoreState(context, wrappedState);
            }
            return restoredObject;
        }
        return stateObj;
    }

    protected FacesContext getFacesContext() {
        if (this._facesContext == null) {
            return FacesContext.getCurrentInstance();
        }
        return this._facesContext;
    }

    boolean isCachedFacesContext() {
        return this._facesContext != null;
    }

    void setCachedFacesContext(FacesContext facesContext) {
        this._facesContext = facesContext;
    }

    protected String getStringValue(FacesContext context, ValueBinding vb) {
        Object value = vb.getValue(context);
        if (value != null) {
            return value.toString();
        }
        return null;
    }
}

