/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0060_pubsub;

import java.util.ArrayList;
import java.util.List;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityUtils;
import org.apache.vysper.xmpp.modules.DefaultDiscoAwareModule;
import org.apache.vysper.xmpp.modules.core.base.handler.MessageHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.NodeDiscoItemsVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubServiceConfiguration;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.ServiceDiscoItemsVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.AbstractPubSubGeneralHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.PubSubCreateNodeHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.PubSubPublishHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.PubSubRetrieveAffiliationsHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.PubSubRetrieveSubscriptionsHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.PubSubSubscribeHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.PubSubUnsubscribeHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.owner.AbstractPubSubOwnerHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.owner.PubSubOwnerConfigureNodeHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.owner.PubSubOwnerDeleteNodeHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.CollectionNode;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.LeafNode;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.storageprovider.CollectionNodeStorageProvider;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.storageprovider.LeafNodeStorageProvider;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ComponentInfoRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Feature;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Identity;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoElement;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequest;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Item;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ItemRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ServiceDiscoveryRequestException;
import org.apache.vysper.xmpp.protocol.NamespaceHandlerDictionary;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.protocol.StanzaProcessor;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.components.Component;
import org.apache.vysper.xmpp.server.components.ComponentStanzaProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishSubscribeModule
extends DefaultDiscoAwareModule
implements Component,
ComponentInfoRequestListener,
ItemRequestListener {
    private PubSubServiceConfiguration serviceConfiguration = null;
    private final Logger logger = LoggerFactory.getLogger(PublishSubscribeModule.class);
    private ComponentStanzaProcessor stanzaProcessor;
    private ServerRuntimeContext serverRuntimeContext;
    protected String subdomain = "pubsub";
    protected Entity fullDomain;

    public PublishSubscribeModule(String subdomain) {
        this();
        this.subdomain = subdomain;
    }

    public PublishSubscribeModule() {
        this(new PubSubServiceConfiguration(new CollectionNode()));
    }

    public PublishSubscribeModule(PubSubServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }

    public void initialize(ServerRuntimeContext serverRuntimeContext) {
        super.initialize(serverRuntimeContext);
        this.serverRuntimeContext = serverRuntimeContext;
        this.fullDomain = EntityUtils.createComponentDomain((String)this.subdomain, (ServerRuntimeContext)serverRuntimeContext);
        CollectionNodeStorageProvider collectionNodeStorageProvider = (CollectionNodeStorageProvider)serverRuntimeContext.getStorageProvider(CollectionNodeStorageProvider.class);
        LeafNodeStorageProvider leafNodeStorageProvider = (LeafNodeStorageProvider)serverRuntimeContext.getStorageProvider(LeafNodeStorageProvider.class);
        if (collectionNodeStorageProvider == null) {
            this.logger.warn("No collection node storage provider found, using the default (in memory)");
        } else {
            this.serviceConfiguration.setCollectionNodeStorageProvider(collectionNodeStorageProvider);
        }
        if (leafNodeStorageProvider == null) {
            this.logger.warn("No leaf node storage provider found, using the default (in memory)");
        } else {
            this.serviceConfiguration.setLeafNodeStorageProvider(leafNodeStorageProvider);
        }
        ComponentStanzaProcessor processor = new ComponentStanzaProcessor(serverRuntimeContext);
        this.addPubsubHandlers(processor);
        this.addPubsubOwnerHandlers(processor);
        processor.addDictionary(new NamespaceHandlerDictionary("http://jabber.org/protocol/pubsub#event", (StanzaHandler)new MessageHandler()));
        this.stanzaProcessor = processor;
        this.serviceConfiguration.setDomainJID(this.fullDomain);
        this.serviceConfiguration.initialize();
    }

    public String getName() {
        return "XEP-0060 Publish-Subscribe";
    }

    public String getVersion() {
        return "1.13rc3";
    }

    public List<InfoElement> getComponentInfosFor(InfoRequest request) throws ServiceDiscoveryRequestException {
        if (!this.fullDomain.getDomain().equals(request.getTo().getDomain())) {
            return null;
        }
        CollectionNode root = this.serviceConfiguration.getRootNode();
        ArrayList<InfoElement> infoElements = new ArrayList<InfoElement>();
        if (request.getNode() == null || request.getNode().length() == 0) {
            infoElements.add((InfoElement)new Identity("pubsub", "service", "Publish-Subscribe"));
            infoElements.add((InfoElement)new Feature("http://jabber.org/protocol/pubsub"));
        } else {
            LeafNode node = root.find(request.getNode());
            infoElements.addAll(node.getNodeInfosFor(request));
        }
        return infoElements;
    }

    protected void addComponentInfoRequestListeners(List<ComponentInfoRequestListener> componentInfoRequestListeners) {
        componentInfoRequestListeners.add(this);
    }

    protected void addItemRequestListeners(List<ItemRequestListener> itemRequestListeners) {
        itemRequestListeners.add(this);
    }

    public List<Item> getItemsFor(InfoRequest request) throws ServiceDiscoveryRequestException {
        CollectionNode root = this.serviceConfiguration.getRootNode();
        List<Item> items = null;
        if (request.getNode() == null || request.getNode().length() == 0) {
            if (this.serverRuntimeContext.getServerEnitity().equals(request.getTo())) {
                ArrayList<Item> componentItem = new ArrayList<Item>();
                componentItem.add(new Item(this.fullDomain));
                return componentItem;
            }
            if (!this.fullDomain.equals(request.getTo())) {
                return null;
            }
            ServiceDiscoItemsVisitor nv = new ServiceDiscoItemsVisitor(this.serviceConfiguration);
            root.acceptNodes(nv);
            items = nv.getNodeItemList();
        } else {
            LeafNode node = root.find(request.getNode());
            NodeDiscoItemsVisitor iv = new NodeDiscoItemsVisitor(request.getTo());
            node.acceptItems(iv);
            items = iv.getItemList();
        }
        return items;
    }

    private void addPubsubOwnerHandlers(ComponentStanzaProcessor dictionary) {
        ArrayList<AbstractPubSubOwnerHandler> pubsubOwnerHandlers = new ArrayList<AbstractPubSubOwnerHandler>();
        pubsubOwnerHandlers.add(new PubSubOwnerConfigureNodeHandler(this.serviceConfiguration));
        pubsubOwnerHandlers.add(new PubSubOwnerDeleteNodeHandler(this.serviceConfiguration));
        dictionary.addDictionary(new NamespaceHandlerDictionary("http://jabber.org/protocol/pubsub#owner", pubsubOwnerHandlers));
    }

    private void addPubsubHandlers(ComponentStanzaProcessor dictionary) {
        ArrayList<AbstractPubSubGeneralHandler> pubsubHandlers = new ArrayList<AbstractPubSubGeneralHandler>();
        pubsubHandlers.add(new PubSubSubscribeHandler(this.serviceConfiguration));
        pubsubHandlers.add(new PubSubUnsubscribeHandler(this.serviceConfiguration));
        pubsubHandlers.add(new PubSubPublishHandler(this.serviceConfiguration));
        pubsubHandlers.add(new PubSubCreateNodeHandler(this.serviceConfiguration));
        pubsubHandlers.add(new PubSubRetrieveSubscriptionsHandler(this.serviceConfiguration));
        pubsubHandlers.add(new PubSubRetrieveAffiliationsHandler(this.serviceConfiguration));
        dictionary.addDictionary(new NamespaceHandlerDictionary("http://jabber.org/protocol/pubsub", pubsubHandlers));
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public StanzaProcessor getStanzaProcessor() {
        return this.stanzaProcessor;
    }
}

