/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jempbox.xmp.Elementable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLUtil {
    private XMLUtil() {
    }

    public static Document parse(InputStream is) throws IOException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (Exception e) {
            IOException thrown = new IOException(e.getMessage());
            throw thrown;
        }
    }

    public static Document parse(InputSource is) throws IOException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (Exception e) {
            IOException thrown = new IOException(e.getMessage());
            throw thrown;
        }
    }

    public static Document parse(String fileName) throws IOException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            return builder.parse(fileName);
        }
        catch (Exception e) {
            IOException thrown = new IOException(e.getMessage());
            throw thrown;
        }
    }

    public static Document newDocument() throws IOException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (Exception e) {
            IOException thrown = new IOException(e.getMessage());
            throw thrown;
        }
    }

    public static Element getElement(Element parent, String elementName) {
        Element retval = null;
        NodeList children = parent.getElementsByTagName(elementName);
        if (children.getLength() > 0) {
            retval = (Element)children.item(0);
        }
        return retval;
    }

    public static Integer getIntValue(Element parent, String nodeName) {
        String intVal = XMLUtil.getStringValue(XMLUtil.getElement(parent, nodeName));
        Integer retval = null;
        if (intVal != null) {
            retval = new Integer(intVal);
        }
        return retval;
    }

    public static void setIntValue(Element parent, String nodeName, Integer intValue) {
        Element currentValue = XMLUtil.getElement(parent, nodeName);
        if (intValue == null) {
            if (currentValue != null) {
                parent.removeChild(currentValue);
            }
        } else {
            if (currentValue == null) {
                currentValue = parent.getOwnerDocument().createElement(nodeName);
                parent.appendChild(currentValue);
            }
            XMLUtil.setStringValue(currentValue, intValue.toString());
        }
    }

    public static String getStringValue(Element parent, String nodeName) {
        return XMLUtil.getStringValue(XMLUtil.getElement(parent, nodeName));
    }

    public static void setStringValue(Element parent, String nodeName, String nodeValue) {
        Element currentValue = XMLUtil.getElement(parent, nodeName);
        if (nodeValue == null) {
            if (currentValue != null) {
                parent.removeChild(currentValue);
            }
        } else {
            if (currentValue == null) {
                currentValue = parent.getOwnerDocument().createElement(nodeName);
                parent.appendChild(currentValue);
            }
            XMLUtil.setStringValue(currentValue, nodeValue);
        }
    }

    public static String getStringValue(Element node) {
        String retval = "";
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node next = children.item(i);
            if (!(next instanceof Text)) continue;
            retval = next.getNodeValue();
        }
        return retval;
    }

    public static void setStringValue(Element node, String value) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node next = children.item(i);
            if (!(next instanceof Text)) continue;
            node.removeChild(next);
        }
        node.appendChild(node.getOwnerDocument().createTextNode(value));
    }

    public static void setElementableValue(Element parent, String name, Elementable node) {
        NodeList nodes = parent.getElementsByTagName(name);
        if (node == null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                parent.removeChild(nodes.item(i));
            }
        } else if (nodes.getLength() == 0) {
            if (parent.hasChildNodes()) {
                Node firstChild = parent.getChildNodes().item(0);
                parent.insertBefore(node.getElement(), firstChild);
            } else {
                parent.appendChild(node.getElement());
            }
        } else {
            Node oldNode = nodes.item(0);
            parent.replaceChild(node.getElement(), oldNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Document doc, String file, String encoding) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", encoding);
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StreamResult result = new StreamResult(new File(file));
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Node doc, OutputStream outStream, String encoding) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", encoding);
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StreamResult result = new StreamResult(outStream);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
    }

    public static byte[] asByteArray(Document doc, String encoding) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", encoding);
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        return writer.getBuffer().toString().getBytes();
    }
}

